﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;

namespace WK5.Core.OnlineShop.Models
{
    public class ShopOrderProduct
    {
        private string _name = String.Empty;

        [CompareField("order_product_id")]
        public int OrderProductId { get; set; }
        [CompareField("order_id")]
        public int OrderId { get; set; }
        [CompareField("product_id")]
        public int ProductId { get; set; }

        public string Name
        {
            get => _name;
            set
            {
                _name = StringErweiterung.FormatString(value);
            }
        }

        public string Model { get; set; } = String.Empty;

        public int Quantity { get; set; }

        public decimal Price { get; set; }

        public decimal Total { get; set; }

        public decimal Tax { get; set; }

        public int Reward { get; set; }
        [CompareField("sonderpreis")]
        public decimal SpecialPrice { get; set; }

    }
}
