﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Threading.Tasks;

namespace WK5.Core.OnlineShop.Models
{
    /// <summary>
    /// Stellt ein Land aus dem Onlineshop dar.
    /// </summary>
    public class ShopLand
    {
        [CompareField("country_id")]
        public int CountryId { get; set; }
        public string Name { get; set; } = String.Empty;
        [CompareField("iso_code_2")]
        public string IsoCode2 { get; set; } = String.Empty;
    }

    /// <summary>
    /// Liefert eine Übersicht über alle verfügbaren Länder im OnlineShop.
    /// </summary>
    public class ShopLandCollection : List<ShopLand>
    {
        private ShopLandCollection()
        {

        }

        public static async Task<ShopLandCollection> CreateAsync()
        {
            using MySqlController2 mySqlController = new MySqlController2();
            ShopLandCollection collection = new ShopLandCollection();
            var data = await mySqlController.SelectDataAsync("SELECT * FROM `country`");
            foreach (DataRow row in data.Rows)
            {
                collection.Add(ObjectErweiterung.DataRowZuObjekt(new ShopLand(), row));
            }

            return collection;
        }
        /// <summary>
        /// Ruft ein Land aus der Collection basierend auf dessen Namen ab.
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public ShopLand? this[string name] => this.Where(x => x.Name.Equals(name, StringComparison.OrdinalIgnoreCase)).FirstOrDefault();
    }
}
