﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Zolltarif
    {
        #region Datenbankfelder
        #region Numerische Werte
        public int ZOTA_N_NR { get; set; }
        public int ZOTA_N_ZOLLSATZNR { get; set; }
        public int ZOTA_N_PROZ { get; set; }
        #endregion
        #region Alphanumerische Werte
        public string ZOTA_A_BEZEICH { get; set; } = String.Empty;
        public string ZOTA_A_EINHEIT { get; set; } = String.Empty;
        public string ZOTA_A_HANDELSBESCHR { get; set; } = String.Empty;
        public string ZOTA_A_ZOLLTARIFNR { get; set; } = String.Empty;
        /// <summary>
        /// Ruft eine Referenzbeschreibung für den Zoll ab, oder legt diese fest.
        /// </summary>
        public string ZOTA_A_REFERENZ { get; set; } = string.Empty;
        #endregion
        #endregion

        /// <summary>
        /// Gibt einen Zolltarif anhand seiner Zolltarif Nummer zurück
        /// </summary>
        /// <param name="ZOTA_N_NR">Die Zolltarifnummer des zu suchenden Zolltarifs</param>
        /// <returns>Gibt ein objekt der Klasse <see cref="Zolltarif"/> zurück</returns>
        public static async Task<Zolltarif?> GetZolltarifAsync(int ZOTA_N_NR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@ZOTA_N_NR", ZOTA_N_NR);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM ZOLLTARIF WHERE ZOTA_N_NR = @ZOTA_N_NR");

            return row == null ? null : ObjectErweiterung.DataRowZuObjekt(new Zolltarif(), row);
        }

        public static async Task<Zolltarif?> GetZolltarifAsync(string artikelnummer, FbController2 fbController)
        {
            fbController.AddParameter("@ARTI_A_NR", artikelnummer);
            DataRow? row = await fbController.SelectRowAsync(@"SELECT Z.* FROM ARTIKEL A INNER JOIN ZOLLTARIF Z ON (Z.ZOTA_N_NR = A.ARTI_N_ZOLLTARIF) WHERE ARTI_A_NR = @ARTI_A_NR");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Zolltarif(), row);
        }

        public static async IAsyncEnumerable<Zolltarif> GetZolltarifeAsync()
        {
            using FbController2 fbController = new FbController2();
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM ZOLLTARIF");

            foreach (DataRow row in data.Rows)
            {
                if (row is not null)
                {
                    yield return ObjectErweiterung.DataRowZuObjekt(new Zolltarif(), row);
                }
            }
        }

        

        
    }
}
