﻿using KarleyLibrary.Attributes;
using System;

namespace WK5.Core.Models
{
    public class Zeiterfassung
    {
        private byte[] _unterschrift = Array.Empty<byte>();
        private string _unterschriftName = string.Empty;
        #region Datenbankfelder
        [CompareField("ZEIT_N_ID")]
        public int Id { get; set; }
        [CompareField("ZEIT_A_TYP")]
        public string Typ { get; set; } = string.Empty;
        [CompareField("ZEIT_N_BELEGNR")]
        public int Belegnummer { get; set; }
        [CompareField("ZEIT_A_KUNDENNR")]
        public string Kundennummer { get; set; } = string.Empty;
        [CompareField("ZEIT_D_START")]
        public DateTime StartDatum { get; set; }
        [CompareField("ZEIT_T_START")]
        public DateTime StartZeit { get; set; }
        [CompareField("ZEIT_D_ENDE")]
        public DateTime EndeDatum { get; set; }
        [CompareField("ZEIT_T_ENDE")]
        public DateTime EndeZeit { get; set; }
        [CompareField("ZEIT_B_NOTIZ")]
        public string Notiz { get; set; } = string.Empty;
        [CompareField("ZEIT_B_UNTERSCHRIFT")]
        public byte[] Unterschrift { get => _unterschrift; set => _unterschrift = value ?? Array.Empty<byte>(); }
        [CompareField("ZEIT_D_UNTERSCHRIFT")]
        public DateTime UnterschriftDatum { get; set; } = DateTime.Now;
        [CompareField("ZEIT_A_UNTERSCHRIFT_NAME")]
        public string UnterschriftName { get => _unterschriftName; set => _unterschriftName = value ?? string.Empty; }
        [CompareField("ZEIT_L_BERECHNET")]
        public bool WirdBerechnet { get; set; } = true;
        [CompareField("ZEIT_L_REMOTE")]
        public bool IstRemote { get; set; }
        [CompareField("ZEIT_N_KILOMETER")]
        public decimal Kilometer { get; set; }
        [CompareField("ZEIT_N_ANLAGEUSER")]
        public int AnlageUserId { get; set; }
        [CompareField("ZEIT_N_LASTUSER")]
        public int LetzterBearbeiterUserId { get; set; }
        [CompareField("ZEIT_TIMESTAMP")]
        public DateTime LetzteÄnderung { get; set; }
        
        #endregion

        public DateTime Start => StartDatum.Date.Add(StartZeit.TimeOfDay);

        public DateTime Ende => EndeDatum.Date.Add(EndeZeit.TimeOfDay);

        public decimal DauerInMinuten
        {
            get
            {
                TimeSpan tmp = Ende - Start;

                return (decimal)((int)tmp.TotalSeconds / 60);
            }
        }

        public Zeiterfassung()
        {

            StartDatum = DateTime.Now.Date;
            StartZeit = StartDatum.Add(new TimeSpan(DateTime.Now.Hour, DateTime.Now.Minute, 0));
            EndeDatum = StartZeit.AddMinutes(15);
            EndeZeit = EndeDatum;
        }

        public void ResetEnde()
        {
            EndeDatum = default;
            EndeZeit = default;
        }
    }
}
