﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Währung
    {
        #region Datenbankfelder
        public string WAEH_A_ZEICHEN { get; set; } = "EUR";
        public decimal WAEH_N_KURS { get; set; }
        public decimal WAEH_N_WECHSELKURS { get; set; }
        public bool WAEH_L_RUNDUNG { get; set; }
        public int WAEH_N_NK { get; set; }
        public DateTime WAEH_D_KURSVOM { get; set; }
        public DateTime WAEH_TIMESTAMP { get; set; }
        public int WAEH_N_LASTUSER { get; set; }
        #endregion
        #region Statische Methoden
        public static async Task<Währung?> GetWährungAsync(string WAEH_A_ZEICHEN)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@WAEH_A_ZEICHEN", WAEH_A_ZEICHEN);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM WAEHRUNG WHERE WAEH_A_ZEICHEN = @WAEH_A_ZEICHEN");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Währung(), row);
        }
        public static async IAsyncEnumerable<Währung> GetWährungenAsync(FbController2 fbController)
        {
            var data = await fbController.SelectDataAsync("SELECT * FROM WAEHRUNG ORDER BY WAEH_A_ZEICHEN");
            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Währung(), row);
            }
        }
        #endregion
    }
}
