﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Linq;

namespace WK5.Core.Models
{
    public class Werbemittel
    {

        private string _name = String.Empty;
        [CompareField("WERB_A_NAME")]
        public string Name
        {
            get => _name;
            set
            {
                if (value != null)
                {
                    _name = value.ToUpper();
                }
            }
        }
        [CompareField("WERB_A_BESCHREIBUNG")]
        public string Beschreibung { get; set; } = String.Empty;
        [CompareField("WERB_L_AKTIV")]
        public bool Aktiv { get; set; } = false;
        [CompareField("WERB_L_OHNEZEITRAUM")]
        public bool OhneZeitraum { get; set; } = true;
        [CompareField("WERB_N_VERSENDEN")]
        public int MaximalVersenden { get; set; } = 1;
        [CompareField("WERB_D_ERSTELLUNG")]
        public DateTime Erstelldatum { get; set; }
        [CompareField("WERB_D_VON")]
        public DateTime Von { get; set; }
        [CompareField("WERB_D_BIS")]
        public DateTime Bis { get; set; }
        [CompareField("WERB_N_LASTUSER")]
        public int LastUser { get; set; }
        [CompareField("WERB_N_ORDER")]
        public int SortOrder { get; set; }
        public List<string> Unterwarengruppen { get; } = new List<string>();
    }

    public class WerbemittelCollection : List<Werbemittel>
    {
        public Werbemittel? this[string name] => this.FirstOrDefault(n => n.Name == name);

        public IEnumerable<Werbemittel> GetAktive()
        {
            // Alle mit Status Aktiv und wo der Zeitraum unbegrenzt ist oder begrenzt und noch nicht abgelaufen
            foreach (Werbemittel werbemittel in this.Where(w => w.Aktiv && (w.OhneZeitraum || (!w.OhneZeitraum && w.Bis < DateTime.Now))))
            {
                yield return werbemittel;
            }
        }
    }
}
