﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Wartung
    {
        private string _kundennummer = string.Empty;
        private string _artikelnummer = string.Empty;
        private string _seriennummer = string.Empty;
        private string _notiz = string.Empty;
        private string _kundenname = string.Empty;

        [CompareField("WART_N_NR")]
        public int WartungsNr { get; set; }
        [CompareField("WART_N_ANLAGEUSER")]
        public int AnlageuserId { get; set; }
        [CompareField("WART_D_DATE")]
        public DateTime Anlagedatum { get; set; }
        [CompareField("WART_A_KUNDENNR")]
        public string Kundennummer { get => _kundennummer; set => _kundennummer = value ?? string.Empty; }
        [CompareField("WART_N_ANSPRECHPARTNER")]
        public int AnsprechpartnerId { get; set; }
        [CompareField("WART_A_ARTIKELNR")]
        public string Artikelnummer { get => _artikelnummer; set => _artikelnummer = value ?? string.Empty; }
        [CompareField("WART_A_SN")]
        public string Seriennummer { get => _seriennummer; set => _seriennummer = value ?? string.Empty; }
        [CompareField("WART_L_ANGENOMMEN")]
        public bool Angenommen { get; set; }
        [CompareField("WART_D_ANGENOMMEN")]
        public DateTime AngenommenDatum { get; set; }
        [CompareField("WART_L_STORNO")]
        public bool Storniert { get; set; }
        [CompareField("WART_D_STORNO")]
        public DateTime StorniertDatum { get; set; }
        [CompareField("WART_L_ERLEDIGT")]
        public bool Erledigt { get; set; }
        [CompareField("WART_D_ERLEDIGT")]
        public DateTime ErledigtDatum { get; set; }
        [CompareField("WART_L_MANUELL")]
        public bool ManuelleWartung { get; set; }
        [CompareField("WART_L_BENACHRICHTIGT")]
        public bool Benachrichtigt { get; set; }
        [CompareField("WART_B_NOTIZ")]
        public string Notiz { get => _notiz; set => _notiz = value ?? string.Empty; }
        [CompareField("WART_N_ANGEBOT")]
        public int Angebot { get; set; }
        [CompareField("WART_N_LASTUSER")]
        public int LetzterBearbeiter { get; set; }
        [CompareField("WART_TIMESTAMP")]
        public DateTime Timestamp { get; set; }

        [CompareField("KUND_A_NAME1")]
        public string Kundenname { get => _kundenname; set => _kundenname = value ?? string.Empty; }
        [CompareField("KUND_L_KEINE_WARTUNGEN")]
        public bool KeineKundenWartungen { get; set; }
    }
}
