﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Warengruppe
    {

        #region Attribute
        [MaxLength(10)]
        public string WAGR_A_NR { get; set; } = String.Empty;
        [MaxLength(40)]
        public string? WAGR_A_BEZEICH { get; set; }
        [MaxLength(60)]
        public string? WAGR_A_BESCH1 { get; set; }
        [MaxLength(60)]
        public string? WAGR_A_BESCH2 { get; set; }
        [MaxLength(60)]
        public string? WAGR_A_BESCH3 { get; set; }
        [MaxLength(5)]
        public string? WAGR_A_EINHEIT { get; set; }
        [MaxLength(5)]
        public string? WAGR_A_PREISEINHEIT { get; set; }


        public int WAGR_N_MITARBEIT { get; set; }
        public int WAGR_N_ERLOESKONTO { get; set; }
        public int WAGR_N_AUFWAND { get; set; }

        public decimal WAGR_N_MINAUFEK { get; set; }
        public decimal WAGR_N_AUFSCHLEK { get; set; }

        public string? WAGR_B_LANGTEXT { get; set; }

        public bool WAGR_L_LAGERF { get; set; }
        public bool WAGR_L_PROV { get; set; }
        public bool WAGR_L_FERTIGUNG { get; set; }
        public bool WAGR_L_GEWICHT { get; set; }
        public bool WAGR_L_SN { get; set; }



        public int WAGR_N_EDI_LEERGUT_KENNZ { get; set; }
        public bool WAGR_L_VERWIEGUNG { get; set; }
        public int WAGR_N_LASTUSER { get; set; }
        public DateTime WAGR_TIMESTAMP { get; set; }
        public int WK5_WAGR_N_PRODUKTMANAGER { get; set; }

        #endregion

        public static async Task<Warengruppe?> GetWarengruppeAsync(string WAGR_A_NR)
        {
            using FbController2 fbController = new FbController2();

            string sql = "SELECT * FROM WARENGRUPPE WHERE WAGR_A_NR = @WAGR_A_NR";
            fbController.AddParameter("@WAGR_A_NR", WAGR_A_NR);

            DataRow? row = await fbController.SelectRowAsync(sql);

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Warengruppe(), row);
        }

        public static async IAsyncEnumerable<Warengruppe> GetWarengruppenAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM WARENGRUPPE ORDER BY WAGR_A_BEZEICH");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Warengruppe(), row);
            }
        }


    }
}
