﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class WareEinlagernArtikel
    {
        private string _artikelnummer = string.Empty;
        private string _lagerplatz = string.Empty;
        private string _bezeichnung1 = string.Empty;
        private string _bezeichnung2 = string.Empty;

        [CompareField("CHAR_A_ARTINR")]
        public string Artikelnummer { get => _artikelnummer; set => _artikelnummer = value ?? string.Empty; }
        public decimal Menge { get; set; }
        [CompareField("ARTI_A_LAGER")]
        public string Lagerplatz { get => _lagerplatz; set => _lagerplatz = value ?? string.Empty; }
        [CompareField("ARTI_A_BEZ1")]
        public string Bezeichnung1 { get => _bezeichnung1; set => _bezeichnung1 = value ?? string.Empty; }
        [CompareField("ARTI_A_BEZ2")]
        public string Bezeichnung2 { get => _bezeichnung2; set => _bezeichnung2 = value ?? string.Empty; }

        public string GetBezeichnung() => Regex.Replace($"{Bezeichnung1} {Bezeichnung2}", "  +/g", " ").Trim();
    }
}
