﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Vertreter : ICloneable
    {
        #region Datenbankfelder
        public string? VERT_A_BANKKONTO { get; set; }
        public string? VERT_A_BANKNAME { get; set; }
        public string? VERT_A_BEARBEITER { get; set; }
        public string? VERT_A_BLZ { get; set; }
        public string? VERT_A_EMAIL { get; set; }
        public string? VERT_A_FAX { get; set; }
        public string? VERT_A_KONTOINHABER { get; set; }
        public string? VERT_A_KUNDENNR { get; set; }
        public string? VERT_A_LAND { get; set; }
        public string? VERT_A_NAME { get; set; }
        public string? VERT_A_NAME3 { get; set; }
        public string? VERT_A_NOTIZ { get; set; }
        public string? VERT_A_ORT { get; set; }
        public string? VERT_A_PLZ { get; set; }
        public string? VERT_A_STR { get; set; }
        public string? VERT_A_TEL1 { get; set; }
        public string? VERT_A_TEL2 { get; set; }
        public string? VERT_A_VORNAME { get; set; }

        public DateTime VERT_D_GEBURTSTAG { get; set; }

        public bool VERT_L_HAENDLER { get; set; }
        public bool VERT_L_INAKTIV { get; set; }
        public bool VERT_L_MWST { get; set; }
        public bool VERT_L_RECHKOPIE { get; set; }

        public int VERT_N_LASTUSER { get; set; }
        public int VERT_N_NR { get; set; }
        public int VERT_N_PERSONALNR { get; set; }

        public decimal VERT_N_PROVISION { get; set; }
        public decimal VERT_N_SOLLGESAMT { get; set; }

        public DateTime VERT_TIMESTAMP { get; set; }
        #endregion

        public string GetName() => Regex.Replace($"{VERT_A_VORNAME} {VERT_A_NAME}", "  +/g", " ").Trim();

        public static async IAsyncEnumerable<Vertreter> GetAllVertreterAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM VERTRETER ORDER BY VERT_A_VORNAME, VERT_A_NAME");
            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Vertreter(), row);
            }
        }

        public static async Task<Vertreter?> GetVertreterAsync(int VERT_N_NR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@VERT_N_NR", VERT_N_NR);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM VERTRETER WHERE VERT_N_NR = @VERT_N_NR");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Vertreter(), row);
        }

        public object Clone()
        {
            return this.MemberwiseClone();
        }
    }
}
