﻿using System;

namespace WK5.Core.Models.Versand
{
    /// <summary>
    /// Fasst Versender und Versandart zu einer Klasse zusammen
    /// </summary>
    public class VersandOption
    {
        public Courier Versender { get; set; }
        public CourierArt Versandart { get; set; }

        public VersandOption(Courier _Versender, CourierArt _VersandArt)
        {
            this.Versender = _Versender;
            this.Versandart = _VersandArt;
        }

        public VersandOption(Beleg beleg)
        {
            Versandart = beleg.LieferbedingungId switch
            {
                1 => CourierArt.UST,
                3 => CourierArt.UEX,
                6 => beleg.Land.Equals("DE", StringComparison.OrdinalIgnoreCase) ? CourierArt.USO : CourierArt.USA,
                10 => CourierArt.ABHOLUNG,
                11 => CourierArt.PALETTE,
                12 => CourierArt.BRIEF,
                _ => throw new VersandNotPossibleException(),
            };
            switch (Versandart)
            {
                case CourierArt.DP0:
                case CourierArt.DP1:
                case CourierArt.DP2:
                case CourierArt.DP3:
                case CourierArt.DP4:
                case CourierArt.DP5:
                case CourierArt.DP6:
                case CourierArt.DPA:
                    Versender = Courier.DPD;
                    break;
                case CourierArt.T01:
                case CourierArt.T02:
                case CourierArt.T03:
                case CourierArt.T04:
                case CourierArt.T05:
                case CourierArt.T06:
                case CourierArt.T07:
                case CourierArt.T08:
                case CourierArt.T09:
                case CourierArt.T10:
                case CourierArt.T12:
                    Versender = Courier.TNT;
                    break;
                case CourierArt.UED:
                case CourierArt.UEP:
                case CourierArt.UEX:
                case CourierArt.UNE:
                case CourierArt.USA:
                case CourierArt.USO:
                case CourierArt.UST:
                    Versender = Courier.UPS;
                    break;
                case CourierArt.FIE:
                case CourierArt.FIP:
                    Versender = Courier.FED;
                    break;
                case CourierArt.MANUELL:
                case CourierArt.PALETTE:
                case CourierArt.TRANSOFLEX:
                case CourierArt.ABHOLUNG:
                case CourierArt.BRIEF:
                    Versender = Courier.MANUAL;
                    break;
                default:
                    break;
            }
        }

        public override string ToString()
        {
            return this.Versender.ToString() + " " + this.Versandart.ToString();
        }
    }
}
