﻿using MbeSoap;
using System;

namespace WK5.Core.Models.Versand
{
    /// <summary>
    /// Stellt eine Kombination von Daten von W4 und MBE zu einem versendeten Paket zusammen.
    /// </summary>
    public class VersandKombi
    {
        /// <summary>
        /// Ruft die Versanddaten von MBE ab.
        /// </summary>
        public ShipmentFullInfoType ShipmentFullInfo { get; }
        public string BELE_A_TYP { get; set; } = String.Empty;
        public int BELE_N_NR { get; set; }
        public W4Paket? Paket { get; }
        public bool IstNeutralerAccount { get; set; }

        public VersandKombi(ShipmentFullInfoType shipmentFullInfo, W4Paket? paket, bool istNeutralerAccount)
        {
            ShipmentFullInfo = shipmentFullInfo;
            Paket = paket;
            this.IstNeutralerAccount = istNeutralerAccount;

            if (paket != null)
            {
                BELE_N_NR = paket.PAKE_N_BELENR;
                BELE_A_TYP = paket.PAKE_A_TYP;
            }
        }

    }
}
