﻿using System.Net;
using System.Text;
using WK5.Core.Models;

namespace WK5.Core.Models.VatChecker
{
    /// <summary>
    /// Stellt eine Anfrage zur Prüfung einer UstId dar.
    /// </summary>
    /// <param name="UstId">Die zu prüfende UstId</param>
    /// <param name="Firmenname">Der zu prüfende Firmenname</param>
    /// <param name="Ort">Der zu prüfende Ort</param>
    /// <param name="Postleitzahl">Die zu prüfende Postleitzahl</param>
    /// <param name="Straße">Die zu prüfende Straße</param>
    /// <param name="Kundennummer">Die zu prüfende Kundennummer</param>
    /// <param name="Drucken">Gibt an, ob ein Beleg der Prüfung gedruckt werden soll, oder nicht.</param>
    /// <param name="Zuordnung">Gibt an, ob ein Kunde, eine Lieferanschrift, oder ein Lieferant geprüft wird.</param>
    /// <param name="LieferanschriftId">Die Id der zu prüfenden Lieferanschrift. Wenn Zuordnung != Lieferanschrift, dann ist dieser Wert 0.</param>
    public record VatRequest(string UstId, string Firmenname, string Ort, string Postleitzahl, string Straße, string Kundennummer, bool Drucken, VatZuordnung Zuordnung, int LieferanschriftId)
    {
        /// <summary>
        /// Generiert die URL-Parameter für eine Vatprüfung beim Finanzamt.
        /// </summary>
        /// <returns></returns>
        public string GetParameter()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(UstId);
            sb.Append($"&Firmenname={WebUtility.UrlEncode(Firmenname)}");
            sb.Append($"&Ort={WebUtility.UrlEncode(Ort)}");
            sb.Append($"&PLZ={WebUtility.UrlEncode(Postleitzahl)}");
            sb.Append($"&Strasse={WebUtility.UrlEncode(Straße)}");
            sb.Append($"&Druck={(Drucken ? "ja" : "nein")}");
            return sb.ToString();
        }
    };
}
