﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Unterwarengruppe
    {
        #region Attribute
        [MaxLength(10)]
        public string UNWG_A_WARENGR { get; set; } = String.Empty;
        [MaxLength(10)]
        public string UNWG_A_NR { get; set; } = String.Empty;
        [MaxLength(40)]
        public string? UNWG_A_BEZEICH { get; set; }
        public DateTime UNWG_TIMESTAMP { get; set; }
        public int UNWG_N_LASTUSER { get; set; }
        #endregion

        public static async Task<Unterwarengruppe?> GetUnterwarengruppeAsync(string UNWG_A_WARENGR, string UNWG_A_NR)
        {
            using FbController2 fbController = new FbController2();

            string sql = "SELECT * FROM UNTERWARENGRUPPE WHERE UNWG_A_WARENGR = @UNWG_A_WARENGR AND UNWG_A_NR = @UNWG_A_NR";
            fbController.AddParameter("@UNWG_A_WARENGR", UNWG_A_WARENGR);
            fbController.AddParameter("@UNWG_A_NR", UNWG_A_NR);

            DataRow? row = await fbController.SelectRowAsync(sql);

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Unterwarengruppe(), row);
        }


        public static async IAsyncEnumerable<Unterwarengruppe> GetUnterwarengruppenAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM UNTERWARENGRUPPE ORDER BY UNWG_A_BEZEICH");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Unterwarengruppe(), row);
            }

        }
    }
}
