﻿using System;
using System.Text;

namespace WK5.Core.Models.Tools.Lagerregal
{
    /// <summary>
    /// Stellt eine Fehlermeldung für nicht vorhandene Chargenmengen eines Artikels dar. Diese Klasse kann nicht vererbt werden.
    /// </summary>
    [Serializable]
    public sealed class ChargenException : Exception
    {
        /// <summary>
        /// Ruft die Artikelnummer des Artikels ab, für den nicht genügend Chargen zum ausbuchen aus der WK5 in der W4 vorhanden sind.
        /// </summary>
        public string Artikelnummer { get; set; }
        /// <summary>
        /// Ruft die durch Chargen noch verfügbare Menge des Artikels ab.
        /// </summary>
        public decimal VerfügbareMenge { get; set; }
        /// <summary>
        /// Erstellt eine neue <see cref="ChargenException"/> für den angegeben Artikel.
        /// </summary>
        /// <param name="artikelnummer"></param>
        /// <param name="verfügbareMenge"></param>
        /// <param name="message"></param>
        public ChargenException(string artikelnummer, decimal verfügbareMenge, string message) : base(message)
        {
            this.Artikelnummer = artikelnummer;
            this.VerfügbareMenge = verfügbareMenge;
        }

        public ChargenException(string artikelnummer, decimal verfügbareMenge, string message, Exception innerException) : base(message, innerException)
        {
            this.Artikelnummer = artikelnummer;
            this.VerfügbareMenge = verfügbareMenge;
        }

        public ChargenException(string artikelnummer, decimal verfügbareMenge)
        {
            this.Artikelnummer = artikelnummer;
            this.VerfügbareMenge = verfügbareMenge;
        }

        /// <summary>
        /// Liefert zusätzliche Hinweise zur aufegretenen <see cref="ChargenException"/>
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine($"----{this.GetType()}----");
            sb.AppendLine($"Betroffener Artikel: {Artikelnummer}");
            sb.AppendLine($"Verfügbare Menge: {VerfügbareMenge}");
            return sb.ToString();
        }
    }
}
