﻿namespace WK5.Core.Models.Tools.Lagerregal
{
    /// <summary>
    /// Stellt eine neue Anfrage zur Buchung für das Lagerregal dar.
    /// </summary>
    public class Buchungsanfrage
    {
        /// <summary>
        /// Ruft die Auftragsnummer ab, oder legt diese fest.
        /// </summary>
        public int BUCHUNG_N_BELEGNR { get; set; }
        /// <summary>
        /// Ruft die eindeutige <see cref="Belegposition.PosId"/> der Belegposition ab, oder legt diese fest.
        /// </summary>
        public int BUCHUNG_N_BPOSNR { get; set; }
        /// <summary>
        /// Ruft die eindeutige StücklistenPositionsId ab, oder legt diese fest.
        /// <para>
        /// Seit der Umstellung auf Bundles ist dieser Wert irrelvant. Nur noch aus Kompatibilitätsgründen im Code.
        /// </para>
        /// </summary>
        public int BUCHUNG_N_STUECKLISTEPOSID { get; set; }
        /// <summary>
        /// Ruft die Menge ab, die für die Position gebucht werden soll, oder legt diese fest.
        /// </summary>
        public decimal BUCHUNG_N_MENGE { get; set; }
        /// <summary>
        /// Ruft die Seriennummer ab, die für die Position gebucht werden soll, oder legt diese fest.
        /// </summary>
        public string? SERIENNUMMER { get; set; }

        public Buchungsanfrage()
        {

        }

        /// <summary>
        /// Dieser Konstruktor ist für die Erstellung einer Buchungsanfrage in der Auftragsübersicht.
        /// </summary>
        /// <param name="position"></param>
        public Buchungsanfrage(PackBelegposition position)
        {
            this.BUCHUNG_N_BELEGNR = position.BPOS_N_NR;
            this.BUCHUNG_N_BPOSNR = position.PosId;
            this.BUCHUNG_N_STUECKLISTEPOSID = position.StücklistenPositionsId;
            this.BUCHUNG_N_MENGE = 1;
            this.SERIENNUMMER = null;

        }
    }
}
