﻿namespace WK5.Core.Models.Tools.Lagerregal
{
    /// <summary>
    /// Stellt einen Möglichen Status für eine <see cref="BuchungResponse"/> dar.
    /// </summary>
    public enum BuchungStatus
    {
        /// <summary>
        /// Die Buchung wurde erfolgreich durchgefügt
        /// </summary>
        OK = 0,
        /// <summary>
        /// Der Auftrag für <see cref="Buchungsanfrage.BUCHUNG_N_BELEGNR"/> konnte nicht gefunden werden
        /// </summary>
        AuftragNichtGefunden,
        /// <summary>
        /// Der Auftrag für <see cref="Buchungsanfrage.BUCHUNG_N_BELEGNR"/> ist nicht zum packen freigegeben.
        /// </summary>
        AuftragNichtFreigegeben,
        /// <summary>
        /// Der Position für <see cref="Buchungsanfrage.BUCHUNG_N_BPOSNR"/> konnte nicht gefunden werden
        /// </summary>
        PositionsIdNichtGefunden,
        /// <summary>
        /// Der Position für <see cref="Buchungsanfrage.BUCHUNG_N_BPOSNR"/> und <see cref="Buchungsanfrage.BUCHUNG_N_STUECKLISTEPOSID"/> konnte nicht gefunden werden
        /// </summary>
        StücklistenPositionsIdNichtGefunden,
        /// <summary>
        /// Zum Buchen der Position wird eine Seriennummer benötigt. Es wurde aber keine Seriennummer mit übermittelt.
        /// </summary>
        SeriennummerBenötigt,
        /// <summary>
        /// Die übergebene Seriennummer konnte im System nicht gefunden werden
        /// </summary>
        SeriennummerNichtGefunden,
        /// <summary>
        /// Die Seriennummer wurde bereits in einer anderen Buchung verwendet und kann nicht erneut ausgebucht werden.
        /// </summary>
        SeriennummerBereitsVerwendet,
        /// <summary>
        /// Die Position ist bereits vollständig gebucht worden. Weitere Buchungen sind nicht notwendig.
        /// </summary>
        BereitsVollständigGebucht,
        /// <summary>
        /// Es wurde versucht eine Stückliste zu buchen. Das ist softwaretechnisch nicht möglich.
        /// </summary>
        BuchungVonStücklisteNichtMöglich,
        /// <summary>
        /// Die generierte SQL ist ungültig. Möglicherweise hat sich an der Datenbankstruktur etwas geändert.
        /// </summary>
        SqlFehler,
        /// <summary>
        /// Die Artikelnummer passt nicht zur Position. Ungültige Buchungsanfrage
        /// </summary>
        UngültigeArtikelnummer
    }
}
