﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class TemplateText
    {
        public string TEXT_A_IDENTIFIER { get; set; } = String.Empty;
        public string TEXT_B_TEXT { get; set; } = String.Empty;

        /// <summary>
        /// Lädt Texte Anhand eines Identifiers aus der Datenbank
        /// </summary>
        /// <param name="identifier"></param>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public static async Task<TemplateTextCollection> GetTemplateTexteAsync(string identifier, FbController2 fbController)
        {
            fbController.AddParameter("@IDENTIFIER", $"{identifier}%");
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM WK5_TEXTE WHERE TEXT_A_IDENTIFIER LIKE @IDENTIFIER");

            TemplateTextCollection collection = new TemplateTextCollection();
            foreach (DataRow row in data.Rows)
            {
                collection.Add(ObjectErweiterung.DataRowZuObjekt(new TemplateText(), row));
            }

            return collection;

        }

    }

    public class TemplateTextCollection : List<TemplateText>
    {
        public TemplateText? this[string TEXT_A_IDENTIFIER] => this.Where(x => x.TEXT_A_IDENTIFIER.Equals(TEXT_A_IDENTIFIER, StringComparison.OrdinalIgnoreCase)).FirstOrDefault();

        public string GetText(string TEXT_A_IDENTIFIER)
        {
            TemplateText? template = this[TEXT_A_IDENTIFIER];

            if (template is null)
            {
                return String.Empty;
            }

            return template.TEXT_B_TEXT;
        }
    }
}
