﻿using KarleyLibrary.Attributes;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static KarleyLibrary.Erweiterungen.StringErweiterung;

namespace WK5.Core.Models
{
    public class Telefonat
    {
        private string _lineAngenommen = string.Empty;
        private string _inOurOut = string.Empty;
        private string _line = string.Empty;
        private string _kundennummer = string.Empty;
        private string _telefonnummer = string.Empty;

        [CompareField("TELE_N_ID")]
        public int Id { get; set; }
        [CompareField("TELE_A_TELNR")]
        public string Telefonnummer { get => _telefonnummer; set => _telefonnummer = value ?? string.Empty; }
        [CompareField("TELE_A_KUNDENNR")]
        public string Kundennummer { get => _kundennummer; set => _kundennummer = value ?? string.Empty; }
        [CompareField("TELE_A_LINE")]
        public string Line { get => _line; set => _line = value ?? string.Empty; }
        [CompareField("TELE_A_INOUT")]
        public string InOurOut { get => _inOurOut; set => _inOurOut = value ?? string.Empty; }
        [CompareField("TELE_A_LINEANGENOMMEN")]
        public string LineAngenommen { get => _lineAngenommen; set => _lineAngenommen = value ?? string.Empty; }
        /// <summary>
        /// Ruft due Dauer des Telefonats in Sekunden ab.
        /// </summary>
        [CompareField("TELE_N_DAUER")]
        public int Dauer { get; set; }
        [CompareField("TELE_TIMESTAMP")]
        public DateTime Timestamp { get; set; }

        public double DauerInMinuten => Dauer / 60;

        public string DauerAnzeige
        {
            get
            {
                if (DauerInMinuten > 0)
                {
                    return $"{DauerInMinuten}m {Dauer - (DauerInMinuten * 60)}s";
                }

                return $"{Dauer}s";
            }
        }

        public Telefonat()
        {

        }


        public Telefonat(string content)
        {
            //Direction
            InOurOut = content.Contains("out") ? "O" : "I";
            //Time
            string tmp = content.Substring(content.IndexOf("acctStoreTime"));
            Timestamp = DateTime.Parse(tmp.Substring(tmp.IndexOf(":") + 2, 18), new CultureInfo("en-US", true));

            //Nr & Mitarbeiter
            tmp = content.Substring(content.IndexOf("acctStoreInfo"));
            String[] tmp2 = tmp.Substring(tmp.IndexOf(":")).Split(';');
            Telefonnummer = OnlyDigits(tmp2[4]);
            if(String.IsNullOrWhiteSpace(Telefonnummer))
            {
                throw new ArgumentException(nameof(Telefonnummer));
            }
            Line = OnlyDigits(tmp2[0]);
            LineAngenommen = OnlyDigits(tmp2[0]);

            if (int.TryParse(tmp2[2], out int minuten) && int.TryParse(tmp2[3], out int sekunden))
            {
                Dauer = (minuten * 60) + sekunden;
            }

        }
    }
}
