﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class StornierTemplate
    {
        public string STTE_A_GRUND { get; set; } = String.Empty;
        public string STTE_B_TEXT { get; set; } = String.Empty;

        public static async Task<StornierTemplateCollection> GetTemplatesAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM WK5_STORNIEREN_TEXTE ORDER BY STTE_A_GRUND");
            StornierTemplateCollection collection = new StornierTemplateCollection();
            foreach (DataRow row in data.Rows)
            {
                collection.Add(ObjectErweiterung.DataRowZuObjekt(new StornierTemplate(), row));
            }

            return collection;
        }
    }

    public class StornierTemplateCollection : List<StornierTemplate>
    {
        public StornierTemplate? this[string STTE_A_GRUND] => this.Where(x => x.STTE_A_GRUND.Equals(STTE_A_GRUND, StringComparison.OrdinalIgnoreCase)).FirstOrDefault();

        public string GetText(string STTE_A_GRUND)
        {
            StornierTemplate? template = this[STTE_A_GRUND];
            if (template is null)
            {
                return String.Empty;
            }

            return template.STTE_B_TEXT;
        }
    }
}
