﻿using KarleyLibrary.Attributes;
using System.Text.RegularExpressions;

namespace WK5.Core.Models.Statistik.Umsatzstatistik
{
    public class ArtikelUmsatzResult
    {
        private string _bezeichnung1 = string.Empty;
        private string _bezeichnung2 = string.Empty;

        [CompareField("BPOS_A_ARTIKELNR")]
        public string Artikelnummer { get; set; } = string.Empty;
        [CompareField("ARTI_A_BEZ1")]
        public string Bezeichnung1 { get => _bezeichnung1; set => _bezeichnung1 = value ?? string.Empty; }
        [CompareField("ARTI_A_BEZ2")]
        public string Bezeichnung2 { get => _bezeichnung2; set => _bezeichnung2 = value ?? string.Empty; }
        public decimal Wert { get; set; }
        public string GetBezeichnung() => Regex.Replace($"{Bezeichnung1} {Bezeichnung2}", "  +/g", " ").Trim();
    }
}
