﻿using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace WK5.Core.Models
{
    public class StaffelpreisCollection : IEnumerable<Staffelpreis>
    {
        public int MaxAnzahl { get; }
        private decimal _bezugspreis { get; set; } = 0.0m;

        public StaffelpreisCollection(int maxAnzahl)
        {
            MaxAnzahl = maxAnzahl;
        }

        public void Clean()
        {
            _staffelPreise.RemoveAll(x => x.Menge <= 0);
        }

        public void Sort()
        {
            _staffelPreise = _staffelPreise.OrderBy(x => x.Menge).ToList();
        }

        public void SetBezugspreis(decimal bezugspreis)
        {
            foreach (Staffelpreis preis in _staffelPreise)
            {
                preis.Bezugspreis = bezugspreis;
            }

            _bezugspreis = bezugspreis;
        }

        public void Add(Staffelpreis preis)
        {
            if (preis is null)
            {
                return;
            }

            preis.Bezugspreis = _bezugspreis;

            if (_staffelPreise.Count < MaxAnzahl)
            {
                _staffelPreise.Add(preis);
            }

            Sort();
        }

        public void Add(decimal menge, decimal preis, decimal rabatt, decimal bezugspreis = 0)
        {
            Add(new Staffelpreis()
            {
                Menge = menge,
                Preis = preis,
                Rabatt = rabatt,
                Bezugspreis = bezugspreis
            });
            Clean();
            Sort();
        }

        public void Remove(int index) => _staffelPreise.RemoveAt(index);

        public void Remove(Staffelpreis preis) => _staffelPreise.Remove(preis);

        public void RemoveLast()
        {
            _staffelPreise.RemoveAt(_staffelPreise.Count - 1);
        }


        public Staffelpreis? Get(int index)
        {
            if (index <= _staffelPreise.Count - 1)
            {
                return _staffelPreise[index];
            }
            else
            {
                return null;
            }
        }

        private List<Staffelpreis> _staffelPreise = new List<Staffelpreis>();

        public IEnumerator<Staffelpreis> GetEnumerator()
        {
            return _staffelPreise.GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }

        public static StaffelpreisCollection FromLieferantenArtikel(Lieferantenartikel lieferantenartikel)
        {
            StaffelpreisCollection staffelpreisCollection = new StaffelpreisCollection(4);
            staffelpreisCollection.SetBezugspreis(lieferantenartikel.ARLI_N_PREIS);
            staffelpreisCollection.Add(lieferantenartikel.ARLI_N_MENGE1,lieferantenartikel.ARLI_N_PREISMENGE1, lieferantenartikel.ARLI_N_RABATTMENGE1);            
            staffelpreisCollection.Add(lieferantenartikel.ARLI_N_MENGE2,lieferantenartikel.ARLI_N_PREISMENGE2, lieferantenartikel.ARLI_N_RABATTMENGE2);            
            staffelpreisCollection.Add(lieferantenartikel.ARLI_N_MENGE3,lieferantenartikel.ARLI_N_PREISMENGE3, lieferantenartikel.ARLI_N_RABATTMENGE3);            
            staffelpreisCollection.Add(lieferantenartikel.ARLI_N_MENGE4,lieferantenartikel.ARLI_N_PREISMENGE4, lieferantenartikel.ARLI_N_RABATTMENGE4);
            return staffelpreisCollection;
        }

        public Staffelpreis? GetStaffelpreis(decimal menge)
        {
            Clean();
            Sort();
            Staffelpreis? tmp = null;
            foreach(Staffelpreis preis in this)
            {
                if(menge > preis.Menge)
                {
                    tmp = preis;
                }
            }
            return tmp;
        }
    }
}
