﻿using System;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Basis.Erweiterungen;

namespace WK5.Core.Models
{
    public class Staffelpreis
    {
        private decimal _menge;
        private decimal _rabatt;
        private decimal _preis;
        private decimal _bezugspreis;

        public decimal Bezugspreis
        {
            get => _bezugspreis; set
            {
                _bezugspreis = value;
                _preis = MathExtensions.BerechnePreis(Bezugspreis, _rabatt);
            }
        }

        public decimal Menge
        {
            get
            {
                return _menge;
            }
            set
            {
                _menge = value;
            }
        }
        public decimal Rabatt
        {
            get
            {
                return _rabatt;
            }
            set
            {
                _rabatt = value;
                if (_rabatt is 0)
                {
                    _preis = Bezugspreis;
                }
                else
                {
                    _preis = MathExtensions.BerechnePreis(Bezugspreis, _rabatt);
                }
            }
        }
        public decimal Preis
        {
            get
            {
                return _preis;
            }

            set
            {
                _preis = value;
                if (_preis is 0)
                {
                    _rabatt = 0;
                }
                else
                {
                    if (Bezugspreis == 0)
                    {
                        _rabatt = 100;
                    }
                    else
                    {
                        _rabatt = MathExtensions.BerechneProzent(Preis, Bezugspreis);
                    }
                }
            }
        }
    }
}
