﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;


namespace WK5.Core.Models
{
    public class SelektionsmerkmalErloes
    {
        #region Datenbankfelder
        public string SS_A_MERKMAL { get; set; } = String.Empty;
        public int SS_N_ANZAHL_KUNDEN { get; set; }
        public int SS_N_ANZAHL_BESTELLUNGEN { get; set; }
        public decimal SS_N_WERT_BESTELLUNGEN { get; set; }
        public decimal SS_N_ROHERTRAG { get; set; }
        #endregion

        public static async IAsyncEnumerable<SelektionsmerkmalErloes> GetSelektionsmerkmalErlöseAsync()
        {
            using FbController2 fbController = new FbController2();
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM WK5_SELEKTIONSSTATISTIK");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt<SelektionsmerkmalErloes>(new SelektionsmerkmalErloes(), row);
            }
        }



    }
}
