﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Selektionsmerkmal
    {

        #region Datenbankfelder
        public int SELE_N_TYP { get; set; }
        public string SELE_A_ID { get; set; } = String.Empty;
        public string SELE_A_BEZ1 { get; set; } = String.Empty;
        public string SELE_A_BEZ2 { get; set; } = String.Empty;
        public DateTime SELE_TIMESTAMP { get; set; }
        public int SELE_N_LASTUSER { get; set; }
        #endregion

        /// <summary>
        /// Gibt eine Liste aller Selektionsmerkmale zurück
        /// </summary>
        public static async IAsyncEnumerable<Selektionsmerkmal> GetSelektionsmerkmaleAsync(SelektionsMerkmalTyp typ, FbController2 fbController)
        {
            fbController.AddParameter("@SELE_N_TYP", (int)typ);
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM SELEKTIONSMERKMAL WHERE SELE_N_TYP = @SELE_N_TYP ORDER BY UPPER(SELE_A_BEZ1)");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Selektionsmerkmal(), row);
            }
        }

        /// <summary>
        /// Holt sich ein Selektionsmerkmal aus der Datenbank anhand seiner ID und Typen
        /// </summary>
        /// <param name="SELE_A_ID">Die zu suchende Selektionsmerkmal Id</param>
        /// <param name="SELE_N_TYP">Der zu suchende SelektionsMerkmalTyp</param>
        public static async Task<Selektionsmerkmal?> GetSelektionsmerkmalAsync(string SELE_A_ID, SelektionsMerkmalTyp SELE_N_TYP)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@SELE_A_ID", SELE_A_ID);
            fbController.AddParameter("@SELE_N_TYP", (int)SELE_N_TYP);
            var row = await fbController.SelectRowAsync("SELECT * FROM SELEKTIONSMERKMAL WHERE SELE_A_ID = @SELE_A_ID AND SELE_N_TYP = @SELE_N_TYP");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Selektionsmerkmal(), row);
        }

        public override string ToString() => $"{SELE_A_BEZ1} {SELE_A_BEZ2}".Trim();

    }

    /// <summary>
    /// Ein Enum das die verschiedenen Selektionsmerkmaltypen beinhaltet
    /// </summary>
    public enum SelektionsMerkmalTyp
    {
        Artikel = 0,
        Kunde = 1,
        Lieferant = 2
    }
}
