﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using MbeSoap;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Drucken.Briefe;

namespace WK5.Core.Models
{
    public class Rma
    {
        #region Felder
        private string _kundennummer = string.Empty;
        private string _artikelnummer = string.Empty;
        private string _seriennummer = string.Empty;
        private string _notiz = string.Empty;
        private string _fehlerangabeKunde = string.Empty;
        private string _fehlerangabeLieferant = string.Empty;
        private string _rücklieferInfo = string.Empty;
        private string _rmaNummerLieferant = string.Empty;
        private string _ticketNummerLieferant = string.Empty;
        private string _ticketNummer = string.Empty;
        private string _gutschriftVonLieferantNummer = string.Empty;
        private string _kundenName1 = string.Empty;
        private string _kundenName2 = string.Empty;
        private string _kundenName3 = string.Empty;
        private string _lieferantAnsprechpartner = string.Empty;
        private string _lieferantAnsprechpartnerEmail = string.Empty;
        private string _kundeAnsprechpartner = string.Empty;
        private string _kundeAnsprechpartnerEmail = string.Empty;
        private string _kundenhinweise = string.Empty;
        #endregion
        #region Properties
        [CompareField("RMA_N_NR")]
        public int Id { get; set; }
        [CompareField("RMA_N_LIEFNR")]
        public int LieferantId { get; set; }
        [CompareField("RMA_N_LIEFADRESSE_LIEFERANT")]
        public int LieferanschriftLieferantId { get; set; }
        [CompareField("RMA_A_PARTNER_LIEFERANT")]
        public string LieferantAnsprechpartner { get => _lieferantAnsprechpartner; set => _lieferantAnsprechpartner = value ?? string.Empty; }
        [CompareField("RMA_A_PARTNER_EMAIL_LIEFERANT")]
        public string LieferantAnsprechpartnerEmail { get => _lieferantAnsprechpartnerEmail; set => _lieferantAnsprechpartnerEmail = value ?? string.Empty; }
        [CompareField("RMA_A_KUNDENNR")]
        public string Kundennummer { get => _kundennummer; set => _kundennummer = value ?? string.Empty; }
        [CompareField("RMA_N_LIEFADRESSE_KUNDE")]
        public int LieferanschriftKundeId { get; set; }
        [CompareField("RMA_A_PARTNER_KUNDE")]
        public string KundeAnsprechpartner { get => _kundeAnsprechpartner; set => _kundeAnsprechpartner = value ?? string.Empty; }
        [CompareField("RMA_A_PARTNER_EMAIL_KUNDE")]
        public string KundeAnsprechpartnerEmail { get => _kundeAnsprechpartnerEmail; set => _kundeAnsprechpartnerEmail = value ?? string.Empty; }
        [CompareField("RMA_N_BELEPOSID")]
        public int BelegposId { get; set; }
        [CompareField("RMA_N_STLPOSID")]
        public int StücklistenPositionsId { get; set; }
        [CompareField("RMA_N_BELEGCHARGE")]
        public int BelegChargenId { get; set; }
        [CompareField("RMA_A_ARTIKELNR")]
        public string Artikelnummer { get => _artikelnummer; set => _artikelnummer = value ?? string.Empty; }
        [CompareField("RMA_A_SERIENNUMMER")]
        public string Seriennummer { get => _seriennummer; set => _seriennummer = value ?? string.Empty; }

        [CompareField("RMA_N_MENGE")]
        public decimal Menge { get; set; } = 1;
        [CompareField("RMA_L_GARANTIE")]
        public bool Garantie { get; set; }
        [CompareField("RMA_L_GARANTIE_LF")]
        public bool GarantieLieferant { get; set; }
        [CompareField("RMA_L_ERLEDIGT")]
        public bool Erledigt { get; set; }
        [CompareField("RMA_D_ANLAGEDATUM")]
        public DateTime Anlagedatum { get; set; }
        [CompareField("RMA_N_NR_LS")]
        public int LieferscheinNummer { get; set; }
        [CompareField("RMA_B_NOTIZ")]
        public string Notiz { get => _notiz; set => _notiz = value ?? string.Empty; }
        [CompareField("RMA_B_FEHLERANGABE_KUNDE")]
        public string FehlerangabeKunde { get => _fehlerangabeKunde; set => _fehlerangabeKunde = value ?? string.Empty; }
        [CompareField("RMA_B_KUNDENHINWEISE")]
        public string Kundenhinweise { get => _kundenhinweise; set => _kundenhinweise = value ?? string.Empty; }
        [CompareField("RMA_B_FEHLERANGABE_LIEFERANT")]
        public string FehlerangabeLieferant { get => _fehlerangabeLieferant; set => _fehlerangabeLieferant = value ?? string.Empty; }
        [CompareField("RMA_B_RUECKLIEFERINFO")]
        public string RücklieferInfo { get => _rücklieferInfo; set => _rücklieferInfo = value ?? string.Empty; }
        [CompareField("RMA_A_RMANR_LIEFERANT")]
        public string RmaNummerLieferant { get => _rmaNummerLieferant; set => _rmaNummerLieferant = value ?? string.Empty; }
        [CompareField("RMA_A_TICKETNR_LIEFERANT")]
        public string TicketNummerLieferant { get => _ticketNummerLieferant; set => _ticketNummerLieferant = value ?? string.Empty; }
        [CompareField("RMA_A_TICKETNR")]
        public string TicketNummer { get => _ticketNummer; set => _ticketNummer = value ?? string.Empty; }
        [CompareField("RMA_N_NEWZUGANG")]
        public int NewZugangId { get; set; }
        [CompareField("RMA_L_RUECKSENDUNG_KUNDE")]
        public bool RücksendungAngefordert { get; set; }
        [CompareField("RMA_D_RUECKSENDUNG_KUNDE")]
        public DateTime RücksendungAngefordertDatum { get; set; }
        [CompareField("RMA_L_EINGANGSBELEG")]
        public bool Eingangsbeleg { get; set; }
        [CompareField("RMA_D_EINGANGSBELEG")]
        public DateTime EingangsbelegDatum { get; set; }
        [CompareField("RMA_L_ANFRAGE_LIEFERANT")]
        public bool AnfrageLieferant { get; set; }
        [CompareField("RMA_D_ANFRAGE_LIEFERANT")]
        public DateTime AnfrageLieferantDatum { get; set; }
        [CompareField("RMA_L_RUECKSENDUNG_LIEFERANT")]
        public bool RücksendungAnLieferant { get; set; }
        [CompareField("RMA_D_RUECKSENDUNG_LIEFERANT")]
        public DateTime RücksendungAnLieferantDatum { get; set; }
        [CompareField("RMA_L_ZURUECK_LIEFERANT")]
        public bool ZurückVonLieferant { get; set; }
        [CompareField("RMA_D_ZURUECK_LIEFERANT")]
        public DateTime ZurückVonLieferantDatum { get; set; }
        [CompareField("RMA_L_ZURUECK_KUNDE")]
        public bool ZurückAnKunde { get; set; }
        [CompareField("RMA_D_ZURUECK_KUNDE")]
        public DateTime ZurückAnKundeDatum { get; set; }
        [CompareField("RMA_L_LIEFERANTENBELASTUNG")]
        public bool Lieferantenbelastung { get; set; }
        [CompareField("RMA_D_LIEFERANTENBELASTUNG")]
        public DateTime LieferantenbelastungDatum { get; set; }
        [CompareField("RMA_L_GUTSCHRIFT_LF")]
        public bool GutschriftVonLieferant { get; set; }
        [CompareField("RMA_A_GUTSCHRIFT_LF")]
        public string GutschriftVonLieferantNummer { get => _gutschriftVonLieferantNummer; set => _gutschriftVonLieferantNummer = value ?? string.Empty; }
        [CompareField("RMA_L_DIREKT_AN_KUNDE")]
        public bool RückversandVonLieferantDirektZumKunden { get; set; }
        [CompareField("RMA_L_DIREKT_AN_LIEFERANT")]
        public bool RückversandVonKundeDirektZumLieferant { get; set; }
        [CompareField("RMA_L_EIGENBESTAND")]
        public bool Eigenbestand { get; set; }
        /// <summary>
        /// Gibt den Typ des Austauschs an
        /// <list type="bullet">
        /// <item>0 gibt an, dass noch kein Austausch durchgeführt worden ist</item>
        /// <item>1 gibt an, dass ein Austausch durch uns durchgeführt wurde</item>
        /// <item>2 gibt an, dass ein Austausch den Lieferanten durchgeführt worden ist</item>
        /// </list>
        /// </summary>
        [CompareField("RMA_N_AUSTAUSCHTYP")]
        public int Austauschtyp { get; set; }
        [CompareField("RMA_N_ANLAGEUSER")]
        public int AnlageUserId { get; set; }
        [CompareField("RMA_N_LASTUSER")]
        public int LetzterBearbeiterId { get; set; }
        [CompareField("RMA_TIMESTAMP")]
        public DateTime LetzteÄnderung { get; set; }
        [CompareField("KUND_A_NAME1")]
        public string KundenName1 { get => _kundenName1; set => _kundenName1 = value ?? string.Empty; }
        [CompareField("KUND_A_NAME2")]
        public string KundenName2 { get => _kundenName2; set => _kundenName2 = value ?? string.Empty; }
        [CompareField("KUND_A_NAME3")]
        public string KundenName3 { get => _kundenName3; set => _kundenName3 = value ?? string.Empty; }
        #endregion

        public string GetKundenname() => Regex.Replace($"{KundenName1} {KundenName2} {KundenName3}", "  +/g", " ").Trim();

        public void ResetPosition()
        {
            Artikelnummer = string.Empty;
            Seriennummer = string.Empty;
            BelegposId = 0;
            StücklistenPositionsId = 0;
            BelegChargenId = 0;
            LieferantId = 0;
            LieferanschriftLieferantId = 0;
        }
    }

    /// <summary>
    /// Stellt eine RMA mit allen Daten dar, die zum Drucken benötigt werden.
    /// </summary>
    public class DruckRma : Rma
    {
        private string _lieferantName1 = string.Empty;
        private string _lieferantName2 = string.Empty;
        private string _lieferantStrasse = string.Empty;
        private string _lieferantPostleitzahl = string.Empty;
        private string _lieferantOrt = string.Empty;
        private string _lieferantLand = string.Empty;
        private string _lieferantLieferanschriftName1 = string.Empty;
        private string _lieferantLieferanschriftName2 = string.Empty;
        private string _lieferantLieferanschriftStrasse = string.Empty;
        private string _lieferantLieferanschriftPostleitzahl = string.Empty;
        private string _lieferantLieferanschriftOrt = string.Empty;
        private string _lieferantLieferanschriftLand = string.Empty;
        private string _lieferantLieferanschriftEmail = string.Empty;
        private string _lieferantAnsprechpartnerName = string.Empty;
        private string _lieferantAnsprechpartnerEmail = string.Empty;
        private string _kundeName1 = string.Empty;
        private string _kundeName2 = string.Empty;
        private string _kundeName3 = string.Empty;
        private string _kundeStrasse = string.Empty;
        private string _kundePostleitzahl = string.Empty;
        private string _kundeOrt = string.Empty;
        private string _kundeLand = string.Empty;
        private string _kundeEmail = string.Empty;
        private string _kundeLieferanschriftName1 = string.Empty;
        private string _kundeLieferanschriftName2 = string.Empty;
        private string _kundeLieferanschriftName3 = string.Empty;
        private string _kundeLieferanschriftStrasse = string.Empty;
        private string _kundeLieferanschriftPostleitzahl = string.Empty;
        private string _kundeLieferanschriftOrt = string.Empty;
        private string _kundeLieferanschriftLand = string.Empty;
        private string _kundeLieferanschriftEmail = string.Empty;
        private string _kundeAnsprechpartnerVorname = string.Empty;
        private string _kundeAnsprechpartnerName = string.Empty;
        private string _kundeAnsprechpartnerEmail = string.Empty;
        private string _zugangLieferscheinNummer = string.Empty;
        private string _zugangRechnungsNummer = string.Empty;
        private string _artikelBezeichnung1 = string.Empty;
        private string _artikelBezeichnung2 = string.Empty;
        private string _artikelBezeichnung3 = string.Empty;
        private string _artikelBezeichnung4 = string.Empty;
        private string _artikelBezeichnung5 = string.Empty;
        private string _lieferantEmail = string.Empty;

        [CompareField("LIEF_A_NAME1")]
        public string LieferantName1 { get => _lieferantName1; set => _lieferantName1 = value ?? string.Empty; }
        [CompareField("LIEF_A_NAME2")]
        public string LieferantName2 { get => _lieferantName2; set => _lieferantName2 = value ?? string.Empty; }
        [CompareField("LIEF_A_STR")]
        public string LieferantStrasse { get => _lieferantStrasse; set => _lieferantStrasse = value ?? string.Empty; }
        [CompareField("LIEF_A_PLZ")]
        public string LieferantPostleitzahl { get => _lieferantPostleitzahl; set => _lieferantPostleitzahl = value ?? string.Empty; }
        [CompareField("LIEF_A_ORT")]
        public string LieferantOrt { get => _lieferantOrt; set => _lieferantOrt = value ?? string.Empty; }
        [CompareField("LIEF_A_LAND")]
        public string LieferantLand { get => _lieferantLand; set => _lieferantLand = value ?? string.Empty; }
        [CompareField("LIEF_A_EMAIL")]
        public string LieferantEmail { get => _lieferantEmail; set => _lieferantEmail = value ?? string.Empty; }
        [CompareField("LIRE_A_NAME1")]
        public string LieferantLieferanschriftName1 { get => _lieferantLieferanschriftName1; set => _lieferantLieferanschriftName1 = value ?? string.Empty; }
        [CompareField("LIRE_A_NAME2")]
        public string LieferantLieferanschriftName2 { get => _lieferantLieferanschriftName2; set => _lieferantLieferanschriftName2 = value ?? string.Empty; }
        [CompareField("LIRE_A_STRASSE")]
        public string LieferantLieferanschriftStrasse { get => _lieferantLieferanschriftStrasse; set => _lieferantLieferanschriftStrasse = value ?? string.Empty; }
        [CompareField("LIRE_A_PLZ")]
        public string LieferantLieferanschriftPostleitzahl { get => _lieferantLieferanschriftPostleitzahl; set => _lieferantLieferanschriftPostleitzahl = value ?? string.Empty; }
        [CompareField("LIRE_A_ORT")]
        public string LieferantLieferanschriftOrt { get => _lieferantLieferanschriftOrt; set => _lieferantLieferanschriftOrt = value ?? string.Empty; }
        [CompareField("LIRE_A_LAND")]
        public string LieferantLieferanschriftLand { get => _lieferantLieferanschriftLand; set => _lieferantLieferanschriftLand = value ?? string.Empty; }
        [CompareField("LIRE_A_EMAIL")]
        public string LieferantLieferanschriftEmail { get => _lieferantLieferanschriftEmail; set => _lieferantLieferanschriftEmail = value ?? string.Empty; }
        [CompareField("KUND_A_NAME1")]
        public string KundeName1 { get => _kundeName1; set => _kundeName1 = value ?? string.Empty; }
        [CompareField("KUND_A_NAME2")]
        public string KundeName2 { get => _kundeName2; set => _kundeName2 = value ?? string.Empty; }
        [CompareField("KUND_A_NAME3")]
        public string KundeName3 { get => _kundeName3; set => _kundeName3 = value ?? string.Empty; }
        [CompareField("KUND_A_STRASSE")]
        public string KundeStrasse { get => _kundeStrasse; set => _kundeStrasse = value ?? string.Empty; }
        [CompareField("KUND_A_PLZ")]
        public string KundePostleitzahl { get => _kundePostleitzahl; set => _kundePostleitzahl = value ?? string.Empty; }
        [CompareField("KUND_A_ORT")]
        public string KundeOrt { get => _kundeOrt; set => _kundeOrt = value ?? string.Empty; }
        [CompareField("KUND_A_LAND")]
        public string KundeLand { get => _kundeLand; set => _kundeLand = value ?? string.Empty; }
        [CompareField("KUND_A_EMAIL")]
        public string KundeEmail { get => _kundeEmail; set => _kundeEmail = value ?? string.Empty; }
        [CompareField("KULA_A_NAME1")]
        public string KundeLieferanschriftName1 { get => _kundeLieferanschriftName1; set => _kundeLieferanschriftName1 = value ?? string.Empty; }
        [CompareField("KULA_A_NAME2")]
        public string KundeLieferanschriftName2 { get => _kundeLieferanschriftName2; set => _kundeLieferanschriftName2 = value ?? string.Empty; }
        [CompareField("KULA_A_NAME3")]
        public string KundeLieferanschriftName3 { get => _kundeLieferanschriftName3; set => _kundeLieferanschriftName3 = value ?? string.Empty; }
        [CompareField("KULA_A_STRASSE")]
        public string KundeLieferanschriftStrasse { get => _kundeLieferanschriftStrasse; set => _kundeLieferanschriftStrasse = value ?? string.Empty; }
        [CompareField("KULA_A_PLZ")]
        public string KundeLieferanschriftPostleitzahl { get => _kundeLieferanschriftPostleitzahl; set => _kundeLieferanschriftPostleitzahl = value ?? string.Empty; }
        [CompareField("KULA_A_ORT")]
        public string KundeLieferanschriftOrt { get => _kundeLieferanschriftOrt; set => _kundeLieferanschriftOrt = value ?? string.Empty; }
        [CompareField("KULA_A_LAND")]
        public string KundeLieferanschriftLand { get => _kundeLieferanschriftLand; set => _kundeLieferanschriftLand = value ?? string.Empty; }
        [CompareField("KULA_A_EMAIL")]
        public string KundeLieferanschriftEmail { get => _kundeLieferanschriftEmail; set => _kundeLieferanschriftEmail = value ?? string.Empty; }

        [CompareField("ZUGA_N_NR")]
        public int ZugangNummer { get; set; }
        [CompareField("ZUGA_D_DATUM")]
        public DateTime ZugangDatum { get; set; }
        [CompareField("ZUGA_A_LS_NR")]
        public string ZugangLieferscheinNummer { get => _zugangLieferscheinNummer; set => _zugangLieferscheinNummer = value ?? string.Empty; }
        [CompareField("ZUGA_D_LS_DATUM")]
        public DateTime ZugangLieferscheinDatum { get; set; }
        [CompareField("ZUGA_A_RE_NR")]
        public string ZugangRechnungsNummer { get => _zugangRechnungsNummer; set => _zugangRechnungsNummer = value ?? string.Empty; }
        [CompareField("ZUGA_D_RE_DATUM")]
        public DateTime ZugangRechnungsDatum { get; set; }

        [CompareField("ARTI_A_BEZ1")]
        public string ArtikelBezeichnung1 { get => _artikelBezeichnung1; set => _artikelBezeichnung1 = value ?? string.Empty; }
        [CompareField("ARTI_A_BEZ2")]
        public string ArtikelBezeichnung2 { get => _artikelBezeichnung2; set => _artikelBezeichnung2 = value ?? string.Empty; }
        [CompareField("ARTI_A_BEZ3")]
        public string ArtikelBezeichnung3 { get => _artikelBezeichnung3; set => _artikelBezeichnung3 = value ?? string.Empty; }
        [CompareField("ARTI_A_BEZ4")]
        public string ArtikelBezeichnung4 { get => _artikelBezeichnung4; set => _artikelBezeichnung4 = value ?? string.Empty; }
        [CompareField("ARTI_A_BEZ5")]
        public string ArtikelBezeichnung5 { get => _artikelBezeichnung5; set => _artikelBezeichnung5 = value ?? string.Empty; }
        public static async Task<DruckRma?> GetDruckRmaAsync(int rmaId, FbController2 fbController)
        {
            string sql = @"SELECT 
RM.*, 
LF.LIEF_A_NAME1, LF.LIEF_A_NAME2, LF.LIEF_A_STR, LF.LIEF_A_PLZ, LF.LIEF_A_ORT, LF.LIEF_A_LAND, LF.LIEF_A_EMAIL,
LFR.LIRE_A_NAME1, LFR.LIRE_A_NAME2, LFR.LIRE_A_STRASSE, LFR.LIRE_A_PLZ, LFR.LIRE_A_ORT, LFR.LIRE_A_LAND, LFR.LIRE_A_EMAIL,  
KU.KUND_A_NAME1, KU.KUND_A_NAME2, KU.KUND_A_NAME3, KU.KUND_A_STRASSE, KU.KUND_A_PLZ, KU.KUND_A_ORT, KU.KUND_A_LAND, KU.KUND_A_EMAIL,
LFA.KULA_A_NAME1, LFA.KULA_A_NAME2, LFA.KULA_A_NAME3, LFA.KULA_A_STRASSE, LFA.KULA_A_PLZ, LFA.KULA_A_ORT, LFA.KULA_A_LAND, LFA.KULA_A_EMAIL,
Z.ZUGA_N_NR, Z.ZUGA_D_DATUM, Z.ZUGA_A_LS_NR, Z.ZUGA_D_LS_DATUM, Z.ZUGA_A_RE_NR, Z.ZUGA_D_RE_DATUM,
A.ARTI_A_BEZ1, A.ARTI_A_BEZ2, A.ARTI_A_BEZ3, A.ARTI_A_BEZ4, A.ARTI_A_BEZ5
FROM RMAS RM
LEFT JOIN LIEFERANTEN LF ON LF.LIEF_N_NR = RM.RMA_N_LIEFNR
LEFT JOIN LIEFRECHNANSCHR LFR ON (LFR.LIRE_N_NR = RM.RMA_N_LIEFADRESSE_LIEFERANT AND LFR.LIRE_N_LIEFNR = RM.RMA_N_LIEFNR)
LEFT JOIN KUNDEN KU ON KU.KUND_A_NR = RM.RMA_A_KUNDENNR
LEFT JOIN LIEFERANSCHRIFTEN LFA ON (LFA.KULA_N_NR = RM.RMA_N_LIEFADRESSE_KUNDE AND LFA.KULA_A_KUNDNR = RM.RMA_A_KUNDENNR)
LEFT JOIN BELEGCHARGEN BC ON BC.BCHA_N_ID = RM.RMA_N_BELEGCHARGE
LEFT JOIN CHARGEN C ON C.CHAR_N_NR = BC.BCHA_N_CHARGE
LEFT JOIN ZUGAENGE Z ON Z.ZUGA_N_NR = C.CHAR_N_STAPELNR
LEFT JOIN ARTIKEL A ON A.ARTI_A_NR = RM.RMA_A_ARTIKELNR
WHERE RMA_N_NR = @RMA_N_NR";

            fbController.AddParameter("RMA_N_NR", rmaId);
            DataRow? row = await fbController.SelectRowAsync(sql);

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new DruckRma(), row);
        }

        public BriefAnschrift GetAnschriftKunde()
        {
            var anschrift = new BriefAnschrift();

            if (LieferanschriftKundeId > 0)
            {
                anschrift.Adresszeile1 = KundeLieferanschriftName1;
                anschrift.Adresszeile2 = KundeLieferanschriftName2;
                anschrift.Adresszeile3 = KundeLieferanschriftName3;
                anschrift.Strasse = KundeLieferanschriftStrasse;
                anschrift.Postleitzahl = KundeLieferanschriftPostleitzahl;
                anschrift.Ort = KundeLieferanschriftOrt;
                anschrift.Land = KundeLieferanschriftLand;
            }
            else
            {
                anschrift.Adresszeile1 = KundeName1;
                anschrift.Adresszeile2 = KundeName2;
                anschrift.Adresszeile3 = KundeName3;
                anschrift.Strasse = KundeStrasse;
                anschrift.Postleitzahl = KundePostleitzahl;
                anschrift.Ort = KundeOrt;
                anschrift.Land = KundeLand;
            }

            if (!string.IsNullOrWhiteSpace(KundeAnsprechpartner))
            {
                anschrift.Adresszeile4 = KundeAnsprechpartner;
            }


            return anschrift;
        }

        public BriefAnschrift GetAnschriftLieferant()
        {
            var anschrift = new BriefAnschrift();

            if (LieferanschriftLieferantId > 0)
            {
                anschrift.Adresszeile1 = LieferantLieferanschriftName1;
                anschrift.Adresszeile2 = LieferantLieferanschriftName2;
                anschrift.Adresszeile3 = string.Empty;
                anschrift.Strasse = LieferantLieferanschriftStrasse;
                anschrift.Postleitzahl = LieferantLieferanschriftPostleitzahl;
                anschrift.Ort = LieferantLieferanschriftOrt;
                anschrift.Land = LieferantLieferanschriftLand;
            }
            else
            {
                anschrift.Adresszeile1 = LieferantName1;
                anschrift.Adresszeile2 = LieferantName2;
                anschrift.Adresszeile3 = string.Empty;
                anschrift.Strasse = LieferantStrasse;
                anschrift.Postleitzahl = LieferantPostleitzahl;
                anschrift.Ort = LieferantOrt;
                anschrift.Land = LieferantLand;
            }

            if (!string.IsNullOrWhiteSpace(LieferantAnsprechpartner))
            {
                anschrift.Adresszeile4 = LieferantAnsprechpartner;
            }

            return anschrift;
        }


        public BriefAnschrift GetVersandAnschriftFürKunde()
        {
            BriefAnschrift anschrift;

            if (RückversandVonKundeDirektZumLieferant)
            {
                anschrift = GetAnschriftLieferant();
            }
            else
            {
                anschrift = GetFirmenAnschrift();
            }

            return anschrift;
        }

        public BriefAnschrift GetVersandAnschriftFürLieferant()
        {
            BriefAnschrift anschrift;
            if (RückversandVonLieferantDirektZumKunden)
            {
                anschrift = GetAnschriftKunde();
            }
            else
            {
                anschrift = GetFirmenAnschrift();
            }

            return anschrift;
        }

        private static BriefAnschrift GetFirmenAnschrift()
        {
            var anschrift = new BriefAnschrift();
            anschrift.Adresszeile1 = GlobalConfig.Configuration.FirmenDaten.Firmenname;
            anschrift.Adresszeile2 = string.Empty;
            anschrift.Adresszeile3 = string.Empty;
            anschrift.Adresszeile4 = string.Empty;
            anschrift.Strasse = GlobalConfig.Configuration.FirmenDaten.Firmenanschrift.Strasse;
            anschrift.Postleitzahl = GlobalConfig.Configuration.FirmenDaten.Firmenanschrift.Postleitzahl;
            anschrift.Ort = GlobalConfig.Configuration.FirmenDaten.Firmenanschrift.Ort;
            anschrift.Land = GlobalConfig.Configuration.FirmenDaten.Firmenanschrift.Land;
            return anschrift;
        }


        public string GetBezeichnung() => Regex.Replace($"{ArtikelBezeichnung1} {ArtikelBezeichnung2} {ArtikelBezeichnung3} {ArtikelBezeichnung4} {ArtikelBezeichnung5}", "  +/g", " ").Trim();
        public string GetEmailLieferant()
        {
            string email = LieferantEmail;

            if (!string.IsNullOrWhiteSpace(LieferantAnsprechpartnerEmail))
            {
                email = LieferantAnsprechpartnerEmail;
            }

            if (!string.IsNullOrWhiteSpace(LieferantLieferanschriftEmail))
            {
                email = LieferantLieferanschriftEmail;
            }

            return email;
        }

        public string GetEmailKunde()
        {
            string email = KundeEmail;

            if (!string.IsNullOrWhiteSpace(KundeAnsprechpartnerEmail))
            {
                email = KundeAnsprechpartnerEmail;
            }

            if (!string.IsNullOrWhiteSpace(KundeLieferanschriftEmail))
            {
                email = KundeLieferanschriftEmail;
            }

            return email;
        }
        public RecipientType ToRecipientType(bool zumLieferanten)
        {
            var anschrift = zumLieferanten ? GetAnschriftLieferant() : GetAnschriftKunde();

            string ansprechpartner = zumLieferanten
                ? LieferantAnsprechpartner
                : KundeAnsprechpartner;

            return VersandErweiterungen.ToRecipientType(
                ansprechpartner,
                anschrift.Adresszeile1,
                anschrift.Adresszeile2,
                anschrift.Adresszeile3,
                anschrift.Strasse,
                anschrift.Postleitzahl,
                anschrift.Ort,
                anschrift.Land,
                GlobalConfig.Configuration.FirmenDaten.Telefon,
                zumLieferanten ? GetEmailLieferant() : GetEmailKunde()
            );
        }

    }
}
