﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;

namespace WK5.Core.Models
{
    public class Rabattbezeichnung
    {
        public string RABZ_A_BEZEICH { get; set; } = String.Empty;
        public DateTime RABZ_TIMESTAMP { get; set; }
        public int RABZ_N_LASTUSER { get; set; }

        public static async IAsyncEnumerable<Rabattbezeichnung> GetRabattbezeichnungenAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM RABATTBEZEICHNUNGEN ORDER BY RABZ_A_BEZEICH");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Rabattbezeichnung(), row);
            }
        }
    }
}
