﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class ProvisionSatz
    {
        private string _notiz = string.Empty;

        public int PROV_N_ID { get; set; }
        public decimal PROV_N_PROZ { get; set; }
        public string PROV_A_NOTIZ { get => _notiz; set => _notiz = value ?? string.Empty; }
        public DateTime PROV_TIMESTAMP { get; set; }
        public int PROV_N_LASTUSER { get; set; }

        public static async Task<ProvisionSatz?> GetProvisionsSatzAsync(int PROV_N_ID, FbController2 fbController)
        {
            fbController.AddParameter("@PROV_N_ID", PROV_N_ID);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM PROVISION WHERE PROV_N_ID = @PROV_N_ID");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new ProvisionSatz(), row);
        }
        public static async IAsyncEnumerable<ProvisionSatz> GetProvisionsSätzeAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM PROVISION");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new ProvisionSatz(), row);
            }
        }
    }
}
