﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Stellt eine Preisliste für einen Kunden aus der W4 dar.
    /// </summary>
    public class Preisliste
    {
        #region Datenbankfelder
        public int PRLI_N_NR { get; set; }
        public string PRLI_A_BEZEICH { get; set; } = String.Empty;
        public DateTime PRLI_TIMESTAMP { get; set; }
        public int PRLI_N_LASTUSER { get; set; }
        public bool PRLI_L_EXPORT { get; set; }
        #endregion

        /// <summary>
        /// Holt sich eine Preisliste anhand der Preislisten ID
        /// </summary>
        /// <param name="PRLI_N_NR">Die Id der zu suchenden Preisliste</param>
        /// <returns>Ein Objekt der Klasse <see cref="Preisliste"/></returns>
        public static async Task<Preisliste?> GetPreislisteAsync(int PRLI_N_NR, FbController2 fbController)
        {
            fbController.AddParameter("@PRLI_N_NR", PRLI_N_NR);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM PREISLISTE WHERE PRLI_N_NR = @PRLI_N_NR");
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Preisliste(), row);
        }

        /// <summary>
        /// Gibt eine Liste aller Preislisten zurück
        /// </summary>
        /// <returns>Eine Liste mit Objekten der Klasse <see cref="Preisliste"/></returns>
        public static async IAsyncEnumerable<Preisliste> GetPreislistenAsync(FbController2 fbController)
        {
            var data = await fbController.SelectDataAsync("SELECT * FROM PREISLISTE ORDER BY PRLI_A_BEZEICH");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Preisliste(), row);
            }
        }


    }
}
