﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Option
    {
        public string OPTI_A_NR { get; set; } = String.Empty;
        public string OPTI_A_BEZEICH { get; set; } = String.Empty;
        public bool OPTI_L_BERECHNEN { get; set; }
        public DateTime OPTI_TIMESTAMP { get; set; }
        public int OPTI_N_LASTUSER { get; set; }

        public static async Task<OptionCollection> GetOptionenAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM OPTIONEN ORDER BY OPTI_A_BEZEICH");

            OptionCollection collection = new OptionCollection();

            foreach (DataRow row in data.Rows)
            {
                collection.Add(ObjectErweiterung.DataRowZuObjekt(new Option(), row));
            }

            return collection;
        }
    }

    public class OptionCollection : List<Option>
    {

        public Option? this[string OPTI_A_NR] => this.Where(x => x.OPTI_A_NR == OPTI_A_NR).FirstOrDefault();

        public bool WirdBerechnet(string? OPTI_A_NR)
        {
            if (OPTI_A_NR is null)
            {
                return true;
            }

            Option? option = this[OPTI_A_NR];

            return option is null ? true : option.OPTI_L_BERECHNEN;
        }


    }

}
