﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Basis;

namespace WK5.Core.Models
{
    public enum NotificationType
    {
        User = 0,
        Group = 1
    }

    public static class NotificationReferenceTyp
    {
        public static string Kundenkontakt = "KUKO";
        public static string Lieferantenkontakt = "LFKO";
    }

    public class Notification
    {
        #region DB Felder
        public int NOTI_N_ID { get; set; }
        public DateTime NOTI_D_DATE { get; set; } = DateTime.Now;        
        public AlertType NOTI_N_ALERTTYP { get; set; }
        public string? NOTI_B_TEXT { get; set; }
        public string? NOTI_A_ICON { get; set; }
        public string? NOTI_A_LINK { get; set; }
        public int NOTI_N_TARGET_ID { get; set; }
        public string NOTI_A_TITEL { get; set; } = String.Empty;
        public NotificationType NOTI_N_TARGET { get; set; }
        public string NOTI_A_REFERENCE_TYP { get; set; } = String.Empty;
        public string NOTI_A_REFERENCE_NR { get; set; }
        #endregion
        public static async Task<Notification?> GetNotificationsAsync(int notificationId)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@NOTI_N_ID", notificationId);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM WK5_NOTIFICATIONS WHERE NOTI_N_ID = @NOTI_N_ID");

            if (row is null)
            {
                return null;
            }

            return ObjectErweiterung.DataRowZuObjekt(new Notification(), row);

        }        

        public static async IAsyncEnumerable<Notification> GetAllNotificationsAsync()
        {
            using FbController2 fbController = new FbController2();
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM WK5_NOTIFICATIONS");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Notification(), row);
            }

        }

        public async Task<Notification> CreateAsync(FbController2 fbController)
        {
            string sql = @"INSERT INTO WK5_NOTIFICATIONS 
(
NOTI_D_DATE,
NOTI_N_ALERTTYP,
NOTI_B_TEXT,
NOTI_A_ICON,
NOTI_A_LINK,
NOTI_N_TARGET_ID,
NOTI_A_TITEL,
NOTI_N_TARGET,
NOTI_A_REFERENCE_TYP,
NOTI_A_REFERENCE_NR
) VALUES (
@NOTI_D_DATE,
@NOTI_N_ALERTTYP,
@NOTI_B_TEXT,
@NOTI_A_ICON,
@NOTI_A_LINK,
@NOTI_N_TARGET_ID,
@NOTI_A_TITEL,
@NOTI_N_TARGET,
@NOTI_A_REFERENCE_TYP,
@NOTI_A_REFERENCE_NR
) RETURNING NOTI_N_ID";

            fbController.AddParameter("@NOTI_D_DATE", NOTI_D_DATE);            
            fbController.AddParameter("@NOTI_N_ALERTTYP", NOTI_N_ALERTTYP);
            fbController.AddParameter("@NOTI_B_TEXT", NOTI_B_TEXT);
            fbController.AddParameter("@NOTI_A_ICON", NOTI_A_ICON);
            fbController.AddParameter("@NOTI_A_LINK", NOTI_A_LINK);
            fbController.AddParameter("@NOTI_N_TARGET_ID", NOTI_N_TARGET_ID);
            fbController.AddParameter("@NOTI_A_TITEL", NOTI_A_TITEL);
            fbController.AddParameter("@NOTI_N_TARGET", NOTI_N_TARGET);
            fbController.AddParameter("@NOTI_A_REFERENCE_TYP", NOTI_A_REFERENCE_TYP);
            fbController.AddParameter("@NOTI_A_REFERENCE_NR", NOTI_A_REFERENCE_NR);

            NOTI_N_ID = Convert.ToInt32(await fbController.FetchObjectAsync(sql));

            return this;
        }

        public async Task<Notification> DeleteAsync(FbController2 fbController)
        {
            string sql = "DELETE FROM WK5_NOTIFICATIONS WHERE NOTI_N_ID = @NOTI_N_ID";
            fbController.AddParameter("@NOTI_N_ID", NOTI_N_ID);

            await fbController.QueryAsync(sql);

            return this;
        }

        public async Task<Notification> UpdateAsync(FbController2 fbController)
        {
            string sql = @"UPDATE WK5_NOTIFICATIONS SET
NOTI_D_DATE = @NOTI_D_DATE,
NOTI_N_TYP = @NOTI_N_TYP,
NOTI_B_TEXT = @NOTI_B_TEXT,
NOTI_A_ICON = @NOTI_A_ICON,
NOTI_A_LINK = @NOTI_A_LINK,
NOTI_N_TARGET_ID = @NOTI_N_TARGET_ID,
NOTI_A_TITEL = @NOTI_A_TITEL,
NOTI_N_TARGET = @NOTI_N_TARGET,
NOTI_A_REFERENCE_TYP = @NOTI_A_REFERENCE_TYP,
NOTI_A_REFERENCE_NR = @NOTI_A_REFERENCE_NR
WHERE NOTI_N_ID = @NOTI_N_ID";

            fbController.AddParameter("@NOTI_D_DATE", NOTI_D_DATE);            
            fbController.AddParameter("@NOTI_N_TYP", NOTI_N_ALERTTYP);
            fbController.AddParameter("@NOTI_B_TEXT", NOTI_B_TEXT);
            fbController.AddParameter("@NOTI_A_ICON", NOTI_A_ICON);
            fbController.AddParameter("@NOTI_A_LINK", NOTI_A_LINK);
            fbController.AddParameter("@NOTI_N_TARGET_ID", NOTI_N_TARGET_ID);
            fbController.AddParameter("@NOTI_N_ID", NOTI_N_ID);
            fbController.AddParameter("@NOTI_A_TITEL", NOTI_A_TITEL);
            fbController.AddParameter("@NOTI_N_TARGET", NOTI_N_TARGET);
            fbController.AddParameter("@NOTI_A_REFERENCE_TYP", NOTI_A_REFERENCE_TYP);
            fbController.AddParameter("@NOTI_A_REFERENCE_NR", NOTI_A_REFERENCE_NR);

            await fbController.QueryAsync(sql);

            return this;
        }

        public IAsyncEnumerable<Notification> GetAllAsync(FbController2 fbController)
        {
            throw new NotImplementedException();
        }
    }
}
