﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Stellt einen Satz zur Berehcnung der Mehrwertsetuer dar.
    /// </summary>
    public class Mehrwertsteuer
    {
        #region Datenbankfelder
        public int MWST_N_NR { get; set; }
        public int MWST_N_LASTUSER { get; set; }
        public decimal MWST_N_PROZENT { get; set; }
        public decimal MWST_N_PROZENTALT { get; set; }
        public string MWST_A_BEMERKUNG { get; set; } = String.Empty;
        public DateTime MWST_D_GUELTIGAB { get; set; }
        public DateTime MWST_TIMESTAMP { get; set; }
        #endregion

        /// <summary>
        /// Holt sich eine Mehrwertsteuer anhand ihrer Nummer
        /// </summary>
        /// <param name="MWST_N_NR">Die zu identifizierende Mehrwertsteuer Nummer</param>
        /// <returns>Gibt ein Objekt der Klasse <see cref="Mehrwertsteuer"/> zruück</returns>
        public static async Task<Mehrwertsteuer?> GetMehrwertsteuerAsync(int MWST_N_NR, FbController2 fbController)
        {
            fbController.AddParameter("@MWST_N_NR", MWST_N_NR);
            var row = await fbController.SelectRowAsync($"SELECT * FROM MEHRWERTSTEUER WHERE MWST_N_NR = @MWST_N_NR");
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Mehrwertsteuer(), row);

        }
        /// <summary>
        /// Liefert den Mehrwertsteuersatz, der für die Berechnung von Versandkosten verwendet wird
        /// </summary>
        /// <returns></returns>
        [Obsolete("Verwenden Sie stattdessen GetVersandMehrwertSteuerAsync(FbController2)")]
        public static async Task<Mehrwertsteuer?> GetVersandMehrwertsteuerAsync()
        {
            using FbController2 fbController = new FbController2();

            var row = await fbController.SelectRowAsync(@"select M.* from KONF_FIRMA K
LEFT JOIN MEHRWERTSTEUER M ON K.KONF_N_UST_VERSAND = M.MWST_N_NR
where KONF_N_INDEX = 1");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Mehrwertsteuer(), row);
        }

        /// <summary>
        /// Liefert den Mehrwertsteuersatz, der für die Berechnung von Versandkosten verwendet wird
        /// </summary>
        /// <returns></returns>
        public static async Task<Mehrwertsteuer?> GetVersandMehrwertsteuerAsync(FbController2 fbController)
        {
            DataRow? row = await fbController.SelectRowAsync(@"select M.* from KONF_FIRMA K
LEFT JOIN MEHRWERTSTEUER M ON K.KONF_N_UST_VERSAND = M.MWST_N_NR
where KONF_N_INDEX = 1");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Mehrwertsteuer(), row);
        }
        /// <summary>
        /// Liefert alle Mehrwertsteuer Sätze aus der Datenbank
        /// </summary>
        /// <returns></returns>
        public static async IAsyncEnumerable<Mehrwertsteuer> GetMehrwertsteuernAsync(FbController2 fbController)
        {
            var data = await fbController.SelectDataAsync("SELECT * FROM MEHRWERTSTEUER");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Mehrwertsteuer(), row);
            }

        }
    }
}
