﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;

namespace WK5.Core.Models
{
    public class Masseinheit
    {
        #region DBFelder
        public string MASS_A_EINHEIT { get; set; } = String.Empty;
        public decimal MASS_N_MENGENFAKTOR { get; set; }
        public bool MASS_L_RUNDFERTIGUNG { get; set; }
        public int MASS_N_NACHKOMMA { get; set; }
        public int MASS_N_FERTRUND { get; set; }
        public int MASS_N_LASTUSER { get; set; }
        public DateTime MASS_TIMESTAMP { get; set; }
        #endregion

        public static async IAsyncEnumerable<Masseinheit> GetMasseinheitenAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM MASSEINHEITEN");

            foreach (DataRow row in data.Rows)
            {
                if (row is not null)
                {
                    yield return ObjectErweiterung.DataRowZuObjekt(new Masseinheit(), row);
                }
            }
        }
    }
}
