﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class ManuellVersand
    {
        public string? MANUELL_A_BELETYP { get; set; }
        public int MANUELL_N_BELENR { get; set; }
        public DateTime MANUELL_T_TIMESTAMP { get; set; }
        public bool MANUELL_L_MAILSENDEN { get; set; }
        public bool MANUELL_L_PAKET { get; set; }
        public int MANUELL_N_PERSONAL { get; set; }

        public Beleg? Beleg { get; set; }

        public async Task LadeBelegAsync()
        {
            if (MANUELL_A_BELETYP is not null)
            {
                using FbController2 fbController = new FbController2();
                Beleg = await Beleg.GetBelegAsync(EnumHelper.GetBelegTyp(MANUELL_A_BELETYP), MANUELL_N_BELENR, fbController);
            }
        }

        public static async Task CreateAsync(string beletyp, int belenr, bool mailSenden, bool paket, int personalnr)
        {
            string query = @"UPDATE OR INSERT INTO WK5_MANUELL_VERSAND (MANUELL_A_BELETYP, MANUELL_N_BELENR,MANUELL_T_TIMESTAMP,MANUELL_L_MAILSENDEN,MANUELL_L_PAKET) VALUES (@TYP,@NR,cast('Now' as date),@SENDEN,@PAKET)";
            using FbController2 fbController = new FbController2(personalnr);
            fbController.AddParameter("@TYP", beletyp);
            fbController.AddParameter("@NR", belenr);
            fbController.AddParameter("@SENDEN", mailSenden.ToFirebirdBool());
            fbController.AddParameter("@PAKET", paket.ToFirebirdBool());
            await fbController.QueryAsync(query);
        }

        public Task CreateAsync()
        {
            if (MANUELL_A_BELETYP is not null)
            {
                return ManuellVersand.CreateAsync(MANUELL_A_BELETYP, MANUELL_N_BELENR, MANUELL_L_MAILSENDEN, MANUELL_L_PAKET, MANUELL_N_PERSONAL);
            }

            return Task.CompletedTask;
        }
    }

}
