﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;

namespace WK5.Core.Models
{
    public class LieferzeitText
    {
        public string LIZE_A_NR { get; set; } = String.Empty;
        public string LIZE_B_TEXT { get; set; } = String.Empty;
        public string LIZE_A_VORSCHAU { get; set; } = String.Empty;
        public DateTime LIZE_TIMESTAMP { get; set; }
        public int LIZE_N_LASTUSER { get; set; }

        public static async IAsyncEnumerable<LieferzeitText> GetLieferzeitTexteAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM LIEFERZEIT_TEXTE ORDER BY LIZE_A_VORSCHAU");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new LieferzeitText(), row);
            }
        }
    }
}
