﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Stellt eine Lieferbedingung für einen Auftrag oder Kunden aus der W4 dar.
    /// </summary>
    public class Lieferbedingung
    {
        public int LIBD_N_NR { get; set; }
        public string LIBD_A_TEXT1 { get; set; } = String.Empty;
        public string? LIBD_A_TEXT2 { get; set; }
        public string? LIBD_A_TEXT3 { get; set; }
        public string? LIBD_A_TEXT4 { get; set; }
        public string? LIBD_A_TEXT5 { get; set; }
        public bool LIBD_L_ABHOLUNG { get; set; }
        public bool LIBD_L_INAKTIV { get; set; }
        public bool LIBD_L_SPEDITION { get; set; }
        public int LIBD_N_LASTUSER { get; set; }
        public DateTime LIBD_TIMESTAMP { get; set; }
        
        public static Task<Lieferbedingung?> GetLieferbedingungAsync(int lieferbedingungId, FbController2 fbController)
        {
            return fbController.SelectRowAsync<Lieferbedingung?>("SELECT LIBD_N_NR, LIBD_A_TEXT1, LIBD_A_TEXT2, LIBD_A_TEXT3, LIBD_A_TEXT4, LIBD_A_TEXT5, LIBD_L_ABHOLUNG, LIBD_L_INAKTIV, LIBD_L_SPEDITION, LIBD_N_LASTUSER, LIBD_TIMESTAMP FROM LIEFERBEDINGUNG WHERE LIBD_N_NR = @LIBD_N_NR", new { LIBD_N_NR = lieferbedingungId });
        }

        /// <summary>
        /// Gibt eine Liste aller Lieferbedingungen zurück
        /// </summary>
        public static async IAsyncEnumerable<Lieferbedingung> GetLieferbedingungenAsync()
        {
            using FbController2 fbController = new FbController2();
            var data = await fbController.SelectDataAsync("SELECT * FROM LIEFERBEDINGUNG ORDER BY LIBD_A_TEXT1");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Lieferbedingung(), row);
            }
        }
    }
}
