﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class LieferantenPartner
    {
        private string _liep_a_name = String.Empty;

        #region Attribute
        public int LIEP_N_LIEFNR { get; set; }
        public int LIEP_N_NR { get; set; }
        public int LIEP_N_LASTUSER { get; set; }
        public bool LIEP_L_HAUPTPARTNER { get; set; }
        public DateTime LIEP_TIMESTAMP { get; set; }
        public string? LIEP_A_BEREICH { get; set; }
        public string? LIEP_A_ADRESSTEXT { get; set; }
        public string? LIEP_A_ANREDE { get; set; }
        public string? LIEP_A_NOTIZ { get; set; }
        public string? LIEP_A_NAME { get => _liep_a_name; set => _liep_a_name = value ?? String.Empty; }
        public string? LIEP_A_TELEFON { get; set; }
        public string? LIEP_A_HANDY { get; set; }
        public string? LIEP_A_TELEFAX { get; set; }
        public string? LIEP_A_EMAIL { get; set; }
        #endregion

        public static async Task<LieferantenPartner?> GetLieferantenPartnerAsync(int LIEP_N_LIEFNR, int LIEP_N_NR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@LIEP_N_LIEFNR", LIEP_N_LIEFNR);
            fbController.AddParameter("@LIEP_N_NR", LIEP_N_NR);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM LIEF_PARTNER WHERE LIEP_N_LIEFNR = @LIEP_N_LIEFNR AND LIEP_N_NR = @LIEP_N_NR");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt<LieferantenPartner>(new LieferantenPartner(), row);
        }

        public static async IAsyncEnumerable<LieferantenPartner> GetLieferantenPartnerAsync(int LIEP_N_LIEFNR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@LIEP_N_LIEFNR", LIEP_N_LIEFNR);
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM LIEF_PARTNER WHERE LIEP_N_LIEFNR = @LIEP_N_LIEFNR");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new LieferantenPartner(), row);
            }
        }

        public static async Task<LieferantenPartner> CreateLieferantenPartnerAsync(LieferantenPartner partner, int userid)
        {
            if (partner.LIEP_N_LIEFNR <= 0)
            {
                throw new ArgumentException($"Es wurde keine Kundennummer in dem Lieferantenpartner übergeben");
            }

            using FbController2 _fbController = new FbController2(userid);

            _fbController.AddParameter("@LIEP_N_LIEFNR", partner.LIEP_N_LIEFNR);
            var idObj = await _fbController.FetchObjectAsync("SELECT CASE WHEN MAX(LIEP_N_NR) IS NULL THEN 0 ELSE MAX(LIEP_N_NR)END + 1 FROM LIEF_PARTNER WHERE LIEP_N_LIEFNR = @LIEP_N_LIEFNR");
            if (idObj is null)
            {
                throw new Exception("#WK5_ADD_LIEFERANTENPARTNER - Es ist ein unbekannter Fehler beim einfügen des Lieferantenpartners aufgetreten. Bitte der Programmierung Bescheid geben");
            }

            int LIEP_N_NR = Convert.ToInt32(idObj);
            partner.LIEP_N_NR = LIEP_N_NR;

            _fbController.AddParameter("@LIEP_N_NR", partner.LIEP_N_NR);
            _fbController.AddParameter("@LIEP_N_LIEFNR", partner.LIEP_N_LIEFNR);
            _fbController.AddParameter("@LIEP_A_NAME", partner.LIEP_A_NAME);
            _fbController.AddParameter("@LIEP_A_BEREICH", partner.LIEP_A_BEREICH);
            _fbController.AddParameter("@LIEP_A_TELEFON", partner.LIEP_A_TELEFON);
            _fbController.AddParameter("@LIEP_A_HANDY", partner.LIEP_A_HANDY);
            _fbController.AddParameter("@LIEP_A_TELEFAX", partner.LIEP_A_TELEFAX);
            _fbController.AddParameter("@LIEP_A_EMAIL", partner.LIEP_A_EMAIL);
            _fbController.AddParameter("@LIEP_A_ADRESSTEXT", partner.LIEP_A_ADRESSTEXT);
            _fbController.AddParameter("@LIEP_A_ANREDE", partner.LIEP_A_ANREDE);
            _fbController.AddParameter("@LIEP_A_NOTIZ", partner.LIEP_A_NOTIZ);
            _fbController.AddParameter("@LIEP_L_HAUPTPARTNER", partner.LIEP_L_HAUPTPARTNER);
            await _fbController.QueryAsync(@"INSERT INTO LIEF_PARTNER
(
LIEP_N_NR, LIEP_N_LIEFNR, LIEP_A_NAME, LIEP_A_BEREICH, LIEP_A_TELEFON, LIEP_A_HANDY,
LIEP_A_TELEFAX, LIEP_A_EMAIL, LIEP_A_ADRESSTEXT, LIEP_A_ANREDE,
LIEP_A_NOTIZ, LIEP_L_HAUPTPARTNER
)
VALUES
(
@LIEP_N_NR, @LIEP_N_LIEFNR, @LIEP_A_NAME, @LIEP_A_BEREICH, @LIEP_A_TELEFON, @LIEP_A_HANDY, 
@LIEP_A_TELEFAX, @LIEP_A_EMAIL, @LIEP_A_ADRESSTEXT, @LIEP_A_ANREDE, 
@LIEP_A_NOTIZ, @LIEP_L_HAUPTPARTNER
)
RETURNING LIEP_N_NR");

            return partner;
        }

        public static async Task<LieferantenPartner> UpdateLieferantenPartnerAsync(LieferantenPartner partner, int userid)
        {
            if (partner.LIEP_N_LIEFNR <= 0)
            {
                throw new ArgumentException("Der Lieferantenpartner verfügt über keine Kundennummer");
            }

            if (partner.LIEP_N_NR <= 0)
            {
                throw new ArgumentException("Der Lieferantenpartner verfügt über keine gültige LIEP_N_NR");
            }

            using FbController2 _fbController = new FbController2(userid);
            _fbController.AddParameter("@LIEP_N_NR", partner.LIEP_N_NR);
            _fbController.AddParameter("@LIEP_N_LIEFNR", partner.LIEP_N_LIEFNR);
            _fbController.AddParameter("@LIEP_A_NAME", partner.LIEP_A_NAME);
            _fbController.AddParameter("@LIEP_A_BEREICH", partner.LIEP_A_BEREICH);
            _fbController.AddParameter("@LIEP_A_TELEFON", partner.LIEP_A_TELEFON);
            _fbController.AddParameter("@LIEP_A_HANDY", partner.LIEP_A_HANDY);
            _fbController.AddParameter("@LIEP_A_TELEFAX", partner.LIEP_A_TELEFAX);
            _fbController.AddParameter("@LIEP_A_EMAIL", partner.LIEP_A_EMAIL);
            _fbController.AddParameter("@LIEP_A_ADRESSTEXT", partner.LIEP_A_ADRESSTEXT);
            _fbController.AddParameter("@LIEP_A_ANREDE", partner.LIEP_A_ANREDE);
            _fbController.AddParameter("@LIEP_A_NOTIZ", partner.LIEP_A_NOTIZ);
            _fbController.AddParameter("@LIEP_L_HAUPTPARTNER", partner.LIEP_L_HAUPTPARTNER);
            await _fbController.QueryAsync(@"UPDATE LIEF_PARTNER SET
LIEP_A_NAME = @LIEP_A_NAME,
LIEP_A_BEREICH = @LIEP_A_BEREICH, LIEP_A_TELEFON = @LIEP_A_TELEFON,
LIEP_A_HANDY = @LIEP_A_HANDY, LIEP_A_TELEFAX = @LIEP_A_TELEFAX, LIEP_A_EMAIL = @LIEP_A_EMAIL,
LIEP_A_ADRESSTEXT = @LIEP_A_ADRESSTEXT, LIEP_A_ANREDE = @LIEP_A_ANREDE,
LIEP_A_NOTIZ = @LIEP_A_NOTIZ, LIEP_L_HAUPTPARTNER = @LIEP_L_HAUPTPARTNER 
WHERE LIEP_N_LIEFNR = @LIEP_N_LIEFNR AND LIEP_N_NR = @LIEP_N_NR");

            return partner;
        }

        public static async Task DeleteLieferantenPartnerAsync(int LIEP_N_LIEFNR, int LIEP_N_NR, int userid)
        {
            using FbController2 fbController = new FbController2(userid);
            fbController.AddParameter("@LIEP_N_LIEFNR", LIEP_N_LIEFNR);
            fbController.AddParameter("@LIEP_N_NR", LIEP_N_NR);
            await fbController.QueryAsync(@"DELETE FROM LIEF_PARTNER WHERE LIEP_N_LIEFNR = @LIEP_N_LIEFNR AND LIEP_N_NR = @LIEP_N_NR");
        }
    }
}
