﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class LieferantenKontakt
    {
        private string? _langnotiz;
        private DateTime _time;
        private DateTime _wiedervorlageTime;
        private string _belegtyp = string.Empty;

        public int LFKO_N_ID { get; set; }
        public int LFKO_N_LFNR { get; set; }
        public int LFKO_N_BESTELLNR { get; set; }
        public int LFKO_N_ART { get; set; }
        public DateTime LFKO_D_DATE { get; set; }
        public DateTime LFKO_T_TIME
        {
            get => _time;
            set
            {
                DateTime dateTime = value;
                dateTime = dateTime.AddSeconds(-dateTime.Second);
                _time = dateTime;
            }
        }
        public string? LFKO_A_NOTIZ { get; set; }
        public int LFKO_N_LASTUSER { get; set; }
        public int LFKO_N_PARTNER { get; set; }
        public string? LFKO_A_BETREFF { get; set; }
        public bool LFKO_L_WIEDERV_ERL { get; set; }
        public DateTime LFKO_D_WIEDERV_DATE { get; set; }
        public DateTime LFKO_T_WIEDERV_TIME
        {
            get => _wiedervorlageTime;
            set
            {
                DateTime dateTime = value;
                dateTime = dateTime.AddSeconds(-dateTime.Second);
                _wiedervorlageTime = dateTime;
            }
        }
        public int LFKO_N_WIEDERV_USER { get; set; }
        public int LFKO_WK5_N_NOTIFICATION_ID { get; set; }
        public string? LFKO_B_LANGNOTIZ
        {
            get
            {
                if (String.IsNullOrWhiteSpace(_langnotiz) && !String.IsNullOrWhiteSpace(LFKO_A_NOTIZ))
                {
                    return LFKO_A_NOTIZ;
                }
                else
                {
                    return _langnotiz;
                }
            }

            set
            {
                _langnotiz = value;
            }
        }

        public string LFKO_A_BELEGTYP { get => _belegtyp; set => _belegtyp = value ?? string.Empty; }
        public int LFKO_N_BELEGNUMMER { get; set; }



        public static async IAsyncEnumerable<LieferantenKontakt> GetLieferantenKontakteAsync(int LIEF_N_NR, [EnumeratorCancellation] CancellationToken cancellationToken)
        {
            if (!cancellationToken.IsCancellationRequested)
            {
                using FbController2 fbController = new FbController2();
                fbController.AddParameter("@LIEF_N_NR", LIEF_N_NR);
                DataTable data = await fbController.SelectDataAsync("SELECT * FROM WK5_LIEFERANTENKONTAKTE WHERE LFKO_N_LFNR = @LIEF_N_NR ORDER BY LFKO_N_ID DESC");
                foreach (DataRow row in data.Rows)
                {
                    if (cancellationToken.IsCancellationRequested)
                    {
                        break;
                    }
                    yield return ObjectErweiterung.DataRowZuObjekt(new LieferantenKontakt(), row);
                }
            }
        }



    }
}
