﻿using KarleyLibrary.Erweiterungen;
using MbeSoap;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class LieferantenAnschrift
    {
        #region Attribute
        public string? LIRE_A_BANKNAME { get; set; }
        public string? LIRE_A_BIC { get; set; }
        public string? LIRE_A_EMAIL { get; set; }
        public string? LIRE_A_FAX { get; set; }
        public string? LIRE_A_IBAN { get; set; }
        public string? LIRE_A_KONTOINHABER { get; set; }
        public string LIRE_A_LAND { get; set; } = String.Empty;
        public string LIRE_A_NAME1 { get; set; } = String.Empty;
        public string? LIRE_A_NAME2 { get; set; }
        public string? LIRE_A_NAME3 { get; set; }
        public string LIRE_A_ORT { get; set; } = String.Empty;
        public string? LIRE_A_PARTNER { get; set; }
        public string LIRE_A_PLZ { get; set; } = String.Empty;
        public string LIRE_A_STRASSE { get; set; } = String.Empty;
        public string? LIRE_A_TEL { get; set; }
        public string? LIRE_WK5_A_FUNKTION { get; set; }
        public int LIRE_N_LASTUSER { get; set; }
        public int LIRE_N_LIEFNR { get; set; }
        public int LIRE_N_NR { get; set; }
        public DateTime LIRE_TIMESTAMP { get; set; }

        #endregion

        public static async IAsyncEnumerable<LieferantenAnschrift> GetAnschriftenAsync(int LIEF_N_NR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@LIRE_N_LIEFNR", LIEF_N_NR);
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM LIEFRECHNANSCHR WHERE LIRE_N_LIEFNR = @LIRE_N_LIEFNR");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new LieferantenAnschrift(), row);
            }
        }

        public static async Task<LieferantenAnschrift?> GetAnschriftAsync(int LIEF_N_NR, int LIRE_N_NR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@LIRE_N_LIEFNR", LIEF_N_NR);
            fbController.AddParameter("@LIRE_N_NR", LIRE_N_NR);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM LIEFRECHNANSCHR WHERE LIRE_N_LIEFNR = @LIRE_N_LIEFNR AND LIRE_N_NR = @LIRE_N_NR");

            if (row is null)
            {
                return null;
            }
            else
            {
                return ObjectErweiterung.DataRowZuObjekt(new LieferantenAnschrift(), row);
            }
        }

        public static async Task<LieferantenAnschrift> CreateLieferantenAnschriftAsync(LieferantenAnschrift anschrift, int userid)
        {
            if (anschrift.LIRE_N_LIEFNR <= 0)
            {
                throw new ArgumentException($"Es wurde keine Lieferantennummer in der Lieferantenanschrift übergeben");
            }

            using FbController2 _fbController = new FbController2(userid);

            _fbController.AddParameter("@LIRE_N_LIEFNR", anschrift.LIRE_N_LIEFNR);
            var idObj = await _fbController.FetchObjectAsync("SELECT CASE WHEN MAX(LIRE_N_NR) IS NULL THEN 0 ELSE MAX(LIRE_N_NR)END + 1 FROM LIEFRECHNANSCHR WHERE LIRE_N_LIEFNR = @LIRE_N_LIEFNR");
            if (idObj is null)
            {
                throw new Exception("#WK5_ADD_LIEFERANTENRECHNUNGSANSCHRIFT - Es ist ein unbekannter Fehler biem einfügen der Lieferantenanschrift aufgetreten. Bitte der Programmierung bescheid geben");
            }

            int LIRE_N_NR = Convert.ToInt32(idObj);
            anschrift.LIRE_N_NR = LIRE_N_NR;
            _fbController.AddParameter("@LIRE_N_NR", anschrift.LIRE_N_NR);
            _fbController.AddParameter("@LIRE_N_LIEFNR", anschrift.LIRE_N_LIEFNR);
            _fbController.AddParameter("@LIRE_A_NAME1", anschrift.LIRE_A_NAME1);
            _fbController.AddParameter("@LIRE_A_NAME2", anschrift.LIRE_A_NAME2);
            _fbController.AddParameter("@LIRE_A_NAME3", anschrift.LIRE_A_NAME3);
            _fbController.AddParameter("@LIRE_A_STRASSE", anschrift.LIRE_A_STRASSE);
            _fbController.AddParameter("@LIRE_A_LAND", anschrift.LIRE_A_LAND);
            _fbController.AddParameter("@LIRE_A_PLZ", anschrift.LIRE_A_PLZ);
            _fbController.AddParameter("@LIRE_A_ORT", anschrift.LIRE_A_ORT);
            _fbController.AddParameter("@LIRE_A_TEL", anschrift.LIRE_A_TEL);
            _fbController.AddParameter("@LIRE_A_FAX", anschrift.LIRE_A_FAX);
            _fbController.AddParameter("@LIRE_A_EMAIL", anschrift.LIRE_A_EMAIL);
            _fbController.AddParameter("@LIRE_A_PARTNER", anschrift.LIRE_A_PARTNER);
            _fbController.AddParameter("@LIRE_A_IBAN", anschrift.LIRE_A_IBAN);
            _fbController.AddParameter("@LIRE_A_BIC", anschrift.LIRE_A_BIC);
            _fbController.AddParameter("@LIRE_A_BANKNAME", anschrift.LIRE_A_BANKNAME);
            _fbController.AddParameter("@LIRE_A_KONTOINHABER", anschrift.LIRE_A_KONTOINHABER);
            _fbController.AddParameter("@LIRE_WK5_A_FUNKTION", anschrift.LIRE_WK5_A_FUNKTION);

            await _fbController.QueryAsync(@"INSERT INTO LIEFRECHNANSCHR
(
LIRE_N_NR, LIRE_N_LIEFNR, LIRE_A_NAME1, LIRE_A_NAME2, LIRE_A_NAME3, LIRE_A_STRASSE, LIRE_A_LAND, LIRE_A_PLZ,
LIRE_A_ORT, LIRE_A_TEL, LIRE_A_FAX, LIRE_A_EMAIL, LIRE_A_PARTNER, LIRE_A_IBAN, LIRE_A_BIC,
LIRE_A_BANKNAME, LIRE_A_KONTOINHABER, LIRE_WK5_A_FUNKTION
)
VALUES
(
@LIRE_N_NR, @LIRE_N_LIEFNR, @LIRE_A_NAME1, @LIRE_A_NAME2, @LIRE_A_NAME3, @LIRE_A_STRASSE, @LIRE_A_LAND, @LIRE_A_PLZ, 
@LIRE_A_ORT, @LIRE_A_TEL, @LIRE_A_FAX, @LIRE_A_EMAIL, @LIRE_A_PARTNER, @LIRE_A_IBAN, @LIRE_A_BIC, 
@LIRE_A_BANKNAME, @LIRE_A_KONTOINHABER, @LIRE_WK5_A_FUNKTION
)");

            return anschrift;
        }

        public static async Task DeleteLieferantenAnschriftAsync(int LIRE_N_LIEFNR, int LIRE_N_NR, int userid)
        {
            using FbController2 _fbController = new FbController2(userid);
            _fbController.AddParameter("@LIRE_N_LIEFNR", LIRE_N_LIEFNR);
            _fbController.AddParameter("@LIRE_N_NR", LIRE_N_NR);
            await _fbController.QueryAsync(@"DELETE FROM LIEFRECHNANSCHR WHERE 
LIRE_N_LIEFNR = @LIRE_N_LIEFNR AND LIRE_N_NR = @LIRE_N_NR");

        }

        public static async Task<LieferantenAnschrift> UpdateLieferantenAnschriftAsync(LieferantenAnschrift anschrift, int userid)
        {
            if (anschrift.LIRE_N_LIEFNR <= 0)
            {
                throw new ArgumentException("Die Lieferantenanschrift verfügt über keine gültige Lieferantennummer");
            }

            if (anschrift.LIRE_N_NR <= 0)
            {
                throw new ArgumentException("Die Lieferantenanschrift verfügt über keine gültige Lieferantennummer");
            }

            using FbController2 _fbController = new FbController2(userid);
            _fbController.AddParameter("@LIRE_N_NR", anschrift.LIRE_N_NR);
            _fbController.AddParameter("@LIRE_N_LIEFNR", anschrift.LIRE_N_LIEFNR);
            _fbController.AddParameter("@LIRE_A_NAME1", anschrift.LIRE_A_NAME1);
            _fbController.AddParameter("@LIRE_A_NAME2", anschrift.LIRE_A_NAME2);
            _fbController.AddParameter("@LIRE_A_NAME3", anschrift.LIRE_A_NAME3);
            _fbController.AddParameter("@LIRE_A_STRASSE", anschrift.LIRE_A_STRASSE);
            _fbController.AddParameter("@LIRE_A_LAND", anschrift.LIRE_A_LAND);
            _fbController.AddParameter("@LIRE_A_PLZ", anschrift.LIRE_A_PLZ);
            _fbController.AddParameter("@LIRE_A_ORT", anschrift.LIRE_A_ORT);
            _fbController.AddParameter("@LIRE_A_TEL", anschrift.LIRE_A_TEL);
            _fbController.AddParameter("@LIRE_A_FAX", anschrift.LIRE_A_FAX);
            _fbController.AddParameter("@LIRE_A_EMAIL", anschrift.LIRE_A_EMAIL);
            _fbController.AddParameter("@LIRE_A_PARTNER", anschrift.LIRE_A_PARTNER);
            _fbController.AddParameter("@LIRE_A_IBAN", anschrift.LIRE_A_IBAN);
            _fbController.AddParameter("@LIRE_A_BIC", anschrift.LIRE_A_BIC);
            _fbController.AddParameter("@LIRE_A_BANKNAME", anschrift.LIRE_A_BANKNAME);
            _fbController.AddParameter("@LIRE_A_KONTOINHABER", anschrift.LIRE_A_KONTOINHABER);
            _fbController.AddParameter("@LIRE_WK5_A_FUNKTION", anschrift.LIRE_WK5_A_FUNKTION);


            await _fbController.QueryAsync(@"UPDATE LIEFRECHNANSCHR SET 
LIRE_A_NAME1 = @LIRE_A_NAME1,  
LIRE_A_NAME2 = @LIRE_A_NAME2,  
LIRE_A_NAME3 = @LIRE_A_NAME3,  
LIRE_A_STRASSE = @LIRE_A_STRASSE,  
LIRE_A_LAND = @LIRE_A_LAND,  
LIRE_A_PLZ = @LIRE_A_PLZ,  
LIRE_A_ORT = @LIRE_A_ORT,  
LIRE_A_TEL = @LIRE_A_TEL,  
LIRE_A_FAX = @LIRE_A_FAX,  
LIRE_A_EMAIL = @LIRE_A_EMAIL,  
LIRE_A_PARTNER = @LIRE_A_PARTNER,  
LIRE_A_IBAN = @LIRE_A_IBAN,  
LIRE_A_BIC = @LIRE_A_BIC,  
LIRE_A_BANKNAME = @LIRE_A_BANKNAME,  
LIRE_A_KONTOINHABER = @LIRE_A_KONTOINHABER,
LIRE_WK5_A_FUNKTION = @LIRE_WK5_A_FUNKTION
WHERE LIRE_N_LIEFNR = @LIRE_N_LIEFNR AND LIRE_N_NR = @LIRE_N_NR");
            return anschrift;


        }

        public override string ToString() => $"{LIRE_A_NAME1} {LIRE_A_NAME2} - {LIRE_A_STRASSE} - {LIRE_A_LAND} - {LIRE_A_PLZ} {LIRE_A_ORT}";
    }
}
