﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    public class Lieferant
    {
        private string _warnhinweise = string.Empty;
        #region DB Felder        
        public string? LIEF_A_BANKNAME { get; set; }
        public string? LIEF_A_BIC { get; set; }
        public string? LIEF_A_BLZ { get; set; }
        public string? LIEF_A_EMAIL { get; set; }
        public string? LIEF_A_FAX { get; set; }
        public string? LIEF_A_IBAN { get; set; }
        public string? LIEF_A_KONTO { get; set; }
        public string? LIEF_A_KONTOINHABER { get; set; }
        public string? LIEF_A_KREDITORNR { get; set; }
        public string? LIEF_A_KUNDENNR { get; set; }
        public string LIEF_A_LAND { get; set; } = "DE";
        public string? LIEF_A_LIEFLAND { get; set; }
        public string? LIEF_A_LIEFNAME1 { get; set; }
        public string? LIEF_A_LIEFNAME2 { get; set; }
        public string? LIEF_A_LIEFORT { get; set; }
        public string? LIEF_A_LIEFPLZ { get; set; }
        public string? LIEF_A_LIEFSTR { get; set; }
        public string LIEF_A_NAME1 { get; set; } = String.Empty;
        public string? LIEF_A_NAME2 { get; set; }
        public string? LIEF_A_NOTIZ { get; set; }
        public string? LIEF_A_ORT { get; set; }
        public string? LIEF_A_PARTNER { get; set; }
        public string? LIEF_A_PLZ { get; set; }
        public string? LIEF_A_SCHECK_LAND { get; set; }
        public string? LIEF_A_SCHECK_NAME1 { get; set; }
        public string? LIEF_A_SCHECK_NAME2 { get; set; }
        public string? LIEF_A_SCHECK_ORT { get; set; }
        public string? LIEF_A_SCHECK_PLZ { get; set; }
        public string? LIEF_A_SCHECK_STR { get; set; }
        public string? LIEF_A_SELEKTION1 { get; set; }
        public string? LIEF_A_SELEKTION2 { get; set; }
        public string? LIEF_A_SELEKTION3 { get; set; }
        public string? LIEF_A_SPRACHE { get; set; }
        public string? LIEF_A_STR { get; set; }
        public string? LIEF_A_SUCHCODE { get; set; }
        public string? LIEF_A_TEL1 { get; set; }
        public string? LIEF_A_TEL2 { get; set; }
        public string? LIEF_A_URL { get; set; }
        public string? LIEF_A_USTIDNR { get; set; }
        public string LIEF_A_WAEHRUNG { get; set; } = String.Empty;
        public string? LIEF_A_ZERT_ERG1 { get; set; }
        public string? LIEF_A_ZERT_ERG2 { get; set; }
        public string? LIEF_A_ZERT_ERG3 { get; set; }
        public string? LIEF_A_ZERT_NR1 { get; set; }
        public string? LIEF_A_ZERT_NR2 { get; set; }
        public string? LIEF_A_ZERT_NR3 { get; set; }
        public string? LIEF_A_ZERT_TYP1 { get; set; }
        public string? LIEF_A_ZERT_TYP2 { get; set; }
        public string? LIEF_A_ZERT_TYP3 { get; set; }
        public DateTime LIEF_D_ERFASSUNG { get; set; }
        public DateTime LIEF_D_PARGR13B { get; set; }
        public DateTime LIEF_D_PARGR48B { get; set; }
        public DateTime LIEF_D_ZERT_AUSG1 { get; set; }
        public DateTime LIEF_D_ZERT_AUSG2 { get; set; }
        public DateTime LIEF_D_ZERT_AUSG3 { get; set; }
        public DateTime LIEF_D_ZERT_GUEL1 { get; set; }
        public DateTime LIEF_D_ZERT_GUEL2 { get; set; }
        public DateTime LIEF_D_ZERT_GUEL3 { get; set; }
        public bool LIEF_L_AKKREDITIER_URK { get; set; }
        public bool LIEF_L_AUSLAND { get; set; }
        public bool LIEF_L_BONUS { get; set; }
        public bool LIEF_L_EUKUNDE { get; set; }
        public bool LIEF_L_KALIBRIERDIENST { get; set; }
        public bool LIEF_L_LIEFABWEICHEND { get; set; }
        public bool LIEF_L_MINDESTLOHN { get; set; }
        public bool LIEF_L_MWST { get; set; }
        public bool LIEF_L_NORMT_ZERTIFIKAT { get; set; }
        public bool LIEF_L_NORMTEILE { get; set; }
        public bool LIEF_L_PARGR13B { get; set; }
        public bool LIEF_L_PARGR48B { get; set; }
        public bool LIEF_L_RUECKGABE { get; set; }
        public bool LIEF_L_SPERRE { get; set; }
        public int LIEF_N_FORM_BE { get; set; }
        public int LIEF_N_FORM_BEM { get; set; }
        public int LIEF_N_FORM_BES { get; set; }
        public int LIEF_N_FORM_LA { get; set; }
        public int LIEF_N_FORM_LAM { get; set; }
        public int LIEF_N_FORM_LB { get; set; }
        public int LIEF_N_FORM_LM { get; set; }
        public int LIEF_N_GRUPPE { get; set; }
        public int LIEF_N_LASTUSER { get; set; }
        public int LIEF_N_LIBD { get; set; }
        public int LIEF_N_MWSTKENNUNG { get; set; }
        public int LIEF_N_NR { get; set; }
        public int LIEF_N_RMAART { get; set; }
        public int LIEF_N_RUECKGABE_TAGE { get; set; }
        public int LIEF_N_SPERRUSERID { get; set; }
        public int LIEF_N_ZABD { get; set; }
        public int LIEF_WK5_N_RUECK_ADRESSE { get; set; }
        public decimal LIEF_N_BONUS1PROZ { get; set; }
        public decimal LIEF_N_BONUS1WERT { get; set; }
        public decimal LIEF_N_BONUS2PROZ { get; set; }
        public decimal LIEF_N_BONUS2WERT { get; set; }
        public decimal LIEF_N_BONUS3PROZ { get; set; }
        public decimal LIEF_N_BONUS3WERT { get; set; }
        public decimal LIEF_N_FRACHTFR_AB { get; set; }
        public decimal LIEF_N_MIDBESTWERT { get; set; }
        public decimal LIEF_N_RABATT { get; set; }
        public DateTime LIEF_TIMESTAMP { get; set; }

        /// <summary>
        /// Gibt an, ob der Lieferant für eine Direktlieferung zugelassen ist.
        /// </summary>
        public bool LIEF_WK5_L_DIREKT_ERLAUBT { get; set; }


        public decimal LIEF_WK5_N_VERSANDKOSTEN { get; set; }
        public decimal LIEF_WK5_N_VERPACKKOSTEN { get; set; }
        public decimal LIEF_WK5_N_VERSICHERKOSTEN { get; set; }
        public string? LIEF_WK5_B_SHOPPASSWORT { get; set; }
        public string? LIEF_WK5_B_SHOPUSERNAME { get; set; }
        public bool LIEF_WK5_L_AUTOIMPORT { get; set; }

        [CompareField("LIEF_WK5_N_MINDERMENGENZUSCHLAG")]
        public decimal Mindermengenzuschlag { get; set; }

        public string LIEF_A_WARNHINWEISE { get => _warnhinweise; set => _warnhinweise = value ?? string.Empty; }

        public bool LIEF_L_EIGENLIEFERANT { get; set; }
        #endregion

        public string NotizAsText
        {
            get
            {
                if (LIEF_A_NOTIZ is null)
                {
                    return String.Empty;
                }
                return LIEF_A_NOTIZ.Replace("\n", "<br>");
            }
        }

        public string WarnhinweisAsText
        {
            get
            {
                if (LIEF_A_WARNHINWEISE is null)
                {
                    return String.Empty;
                }
                return LIEF_A_WARNHINWEISE.Replace("\n", "<br>");
            }
        }
        public static async Task<Lieferant?> GetLieferantAsync(int LIEF_N_NR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@LIEFNR", LIEF_N_NR);
            var row = await fbController.SelectRowAsync("SELECT * FROM LIEFERANTEN WHERE LIEF_N_NR = @LIEFNR");
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt<Lieferant>(new Lieferant(), row);
        }

        public static async Task<Lieferant> CreateLieferantAsync(Lieferant lieferant, int userid)
        {
            using FbController2 _fbController = new FbController2(userid);
            await _fbController.StartTransactionAsync();
            List<int> freieLieferantennummern = await Lieferant.GetFreieLieferantennummernW4Async().ToListAsync();
            if (freieLieferantennummern.Count < 1)
            {
                throw new IndexOutOfRangeException("Es gibt keine freien Lieferatennummern mehr");
            }
            int lieferantennummer = freieLieferantennummern.First();

            #region Parameter
            _fbController.AddParameter("@LIEF_N_NR", lieferantennummer);
            _fbController.AddParameter("@LIEF_A_SUCHCODE", lieferant.LIEF_A_SUCHCODE);
            _fbController.AddParameter("@LIEF_A_NAME1", lieferant.LIEF_A_NAME1);
            _fbController.AddParameter("@LIEF_A_NAME2", lieferant.LIEF_A_NAME2);
            _fbController.AddParameter("@LIEF_A_PARTNER", lieferant.LIEF_A_PARTNER);
            _fbController.AddParameter("@LIEF_A_STR", lieferant.LIEF_A_STR);
            _fbController.AddParameter("@LIEF_A_LAND", lieferant.LIEF_A_LAND);
            _fbController.AddParameter("@LIEF_A_PLZ", lieferant.LIEF_A_PLZ);
            _fbController.AddParameter("@LIEF_A_ORT", lieferant.LIEF_A_ORT);
            _fbController.AddParameter("@LIEF_A_TEL1", lieferant.LIEF_A_TEL1);
            _fbController.AddParameter("@LIEF_A_TEL2", lieferant.LIEF_A_TEL2);
            _fbController.AddParameter("@LIEF_A_FAX", lieferant.LIEF_A_FAX);
            _fbController.AddParameter("@LIEF_A_EMAIL", lieferant.LIEF_A_EMAIL);
            _fbController.AddParameter("@LIEF_A_URL", lieferant.LIEF_A_URL);
            _fbController.AddParameter("@LIEF_L_SPERRE", lieferant.LIEF_L_SPERRE ? "Y" : "N");
            _fbController.AddParameter("@LIEF_L_MWST", lieferant.LIEF_L_MWST ? "Y" : "N");
            _fbController.AddParameter("@LIEF_N_MWSTKENNUNG", lieferant.LIEF_N_MWSTKENNUNG);
            _fbController.AddParameter("@LIEF_L_EUKUNDE", lieferant.LIEF_L_EUKUNDE ? "Y" : "N");
            _fbController.AddParameter("@LIEF_L_AUSLAND", lieferant.LIEF_L_AUSLAND ? "Y" : "N");
            _fbController.AddParameter("@LIEF_A_NOTIZ", lieferant.LIEF_A_NOTIZ);
            _fbController.AddParameter("@LIEF_A_WAEHRUNG", lieferant.LIEF_A_WAEHRUNG);
            _fbController.AddParameter("@LIEF_A_KUNDENNR", lieferant.LIEF_A_KUNDENNR);
            _fbController.AddParameter("@LIEF_A_KONTO", lieferant.LIEF_A_KONTO);
            _fbController.AddParameter("@LIEF_A_IBAN", lieferant.LIEF_A_IBAN);
            _fbController.AddParameter("@LIEF_A_BLZ", lieferant.LIEF_A_BLZ);
            _fbController.AddParameter("@LIEF_A_BIC", lieferant.LIEF_A_BIC);
            _fbController.AddParameter("@LIEF_A_KONTOINHABER", lieferant.LIEF_A_KONTOINHABER);
            _fbController.AddParameter("@LIEF_A_BANKNAME", lieferant.LIEF_A_BANKNAME);
            _fbController.AddParameter("@LIEF_N_LIBD", lieferant.LIEF_N_LIBD);
            _fbController.AddParameter("@LIEF_N_ZABD", lieferant.LIEF_N_ZABD);
            _fbController.AddParameter("@LIEF_N_MIDBESTWERT", lieferant.LIEF_N_MIDBESTWERT);
            _fbController.AddParameter("@LIEF_N_FRACHTFR_AB", lieferant.LIEF_N_FRACHTFR_AB);
            _fbController.AddParameter("@LIEF_A_KREDITORNR", lieferant.LIEF_A_KREDITORNR);
            _fbController.AddParameter("@LIEF_A_SELEKTION1", lieferant.LIEF_A_SELEKTION1);
            _fbController.AddParameter("@LIEF_A_SELEKTION2", lieferant.LIEF_A_SELEKTION2);
            _fbController.AddParameter("@LIEF_A_SELEKTION3", lieferant.LIEF_A_SELEKTION3);
            _fbController.AddParameter("@LIEF_L_LIEFABWEICHEND", lieferant.LIEF_L_LIEFABWEICHEND ? "Y" : "N");
            _fbController.AddParameter("@LIEF_A_USTIDNR", lieferant.LIEF_A_USTIDNR);
            _fbController.AddParameter("@LIEF_N_RABATT", lieferant.LIEF_N_RABATT);
            _fbController.AddParameter("@LIEF_L_RUECKGABE", lieferant.LIEF_L_RUECKGABE ? "Y" : "N");
            _fbController.AddParameter("@LIEF_N_RUECKGABE_TAGE", lieferant.LIEF_N_RUECKGABE_TAGE);
            _fbController.AddParameter("@LIEF_L_BONUS", lieferant.LIEF_L_BONUS ? "Y" : "N");
            _fbController.AddParameter("@LIEF_N_BONUS1PROZ", lieferant.LIEF_N_BONUS1PROZ);
            _fbController.AddParameter("@LIEF_N_BONUS1WERT", lieferant.LIEF_N_BONUS1WERT);
            _fbController.AddParameter("@LIEF_N_BONUS2PROZ", lieferant.LIEF_N_BONUS2PROZ);
            _fbController.AddParameter("@LIEF_N_BONUS2WERT", lieferant.LIEF_N_BONUS2WERT);
            _fbController.AddParameter("@LIEF_N_BONUS3PROZ", lieferant.LIEF_N_BONUS3PROZ);
            _fbController.AddParameter("@LIEF_N_BONUS3WERT", lieferant.LIEF_N_BONUS3WERT);
            _fbController.AddParameter("@LIEF_N_RMAART", lieferant.LIEF_N_RMAART);
            _fbController.AddParameter("@LIEF_L_MINDESTLOHN", lieferant.LIEF_L_MINDESTLOHN ? "Y" : "N");
            _fbController.AddParameter("@LIEF_L_PARGR13B", lieferant.LIEF_L_PARGR13B ? "Y" : "N");
            _fbController.AddParameter("@LIEF_D_PARGR13B", lieferant.LIEF_D_PARGR13B);
            _fbController.AddParameter("@LIEF_L_PARGR48B", lieferant.LIEF_L_PARGR48B ? "Y" : "N");
            _fbController.AddParameter("@LIEF_D_PARGR48B", lieferant.LIEF_D_PARGR48B);
            _fbController.AddParameter("@LIEF_WK5_N_VERSANDKOSTEN", lieferant.LIEF_WK5_N_VERSANDKOSTEN);
            _fbController.AddParameter("@LIEF_WK5_N_VERPACKKOSTEN", lieferant.LIEF_WK5_N_VERPACKKOSTEN);
            _fbController.AddParameter("@LIEF_WK5_N_VERSICHERKOSTEN", lieferant.LIEF_WK5_N_VERSICHERKOSTEN);
            _fbController.AddParameter("@LIEF_WK5_B_SHOPPASSWORT", lieferant.LIEF_WK5_B_SHOPPASSWORT);
            _fbController.AddParameter("@LIEF_WK5_B_SHOPUSERNAME", lieferant.LIEF_WK5_B_SHOPUSERNAME);
            _fbController.AddParameter("@LIEF_WK5_L_AUTOIMPORT", lieferant.LIEF_WK5_L_AUTOIMPORT);
            _fbController.AddParameter("@LIEF_WK5_N_MINDERMENGENZUSCHLAG", lieferant.Mindermengenzuschlag);
            _fbController.AddParameter("@LIEF_A_WARNHINWEISE", lieferant.LIEF_A_WARNHINWEISE);
            _fbController.AddParameter("@LIEF_L_EIGENLIEFERANT", lieferant.LIEF_L_EIGENLIEFERANT.ToFirebirdBool());
            #endregion
            await _fbController.QueryAsync(@"INSERT INTO LIEFERANTEN
(
LIEF_N_NR, 
LIEF_A_SUCHCODE, 
LIEF_A_NAME1, 
LIEF_A_NAME2, 
LIEF_A_PARTNER, 
LIEF_A_STR, 
LIEF_A_LAND, 
LIEF_A_PLZ,
LIEF_A_ORT, 
LIEF_A_TEL1, 
LIEF_A_TEL2, 
LIEF_A_FAX, 
LIEF_A_EMAIL, 
LIEF_A_URL, 
LIEF_L_SPERRE, 
LIEF_L_MWST,
LIEF_N_MWSTKENNUNG, 
LIEF_L_EUKUNDE, 
LIEF_L_AUSLAND, 
LIEF_A_NOTIZ, 
LIEF_A_WAEHRUNG, 
LIEF_A_KUNDENNR, 
LIEF_A_KONTO,
LIEF_A_IBAN, 
LIEF_A_BLZ, 
LIEF_A_BIC, 
LIEF_A_KONTOINHABER, 
LIEF_A_BANKNAME, 
LIEF_N_LIBD, 
LIEF_N_ZABD, 
LIEF_N_MIDBESTWERT,
LIEF_N_FRACHTFR_AB, 
LIEF_A_KREDITORNR, 
LIEF_A_SELEKTION1, 
LIEF_A_SELEKTION2, 
LIEF_A_SELEKTION3, 
LIEF_L_LIEFABWEICHEND,
LIEF_A_USTIDNR, 
LIEF_N_RABATT, 
LIEF_L_RUECKGABE, 
LIEF_N_RUECKGABE_TAGE, 
LIEF_L_BONUS, 
LIEF_N_BONUS1PROZ, 
LIEF_N_BONUS1WERT,
LIEF_N_BONUS2PROZ, 
LIEF_N_BONUS2WERT, 
LIEF_N_BONUS3PROZ, 
LIEF_N_BONUS3WERT, 
LIEF_N_RMAART, 
LIEF_L_MINDESTLOHN,
LIEF_L_PARGR13B,
LIEF_D_PARGR13B, 
LIEF_L_PARGR48B, 
LIEF_D_PARGR48B, 
LIEF_WK5_N_VERSANDKOSTEN, 
LIEF_WK5_N_VERPACKKOSTEN, 
LIEF_WK5_N_VERSICHERKOSTEN,
LIEF_WK5_B_SHOPPASSWORT, 
LIEF_WK5_B_SHOPUSERNAME, 
LIEF_WK5_L_AUTOIMPORT, 
LIEF_WK5_N_MINDERMENGENZUSCHLAG,
LIEF_A_WARNHINWEISE,
LIEF_L_EIGENLIEFERANT
)
VALUES
(
@LIEF_N_NR, 
@LIEF_A_SUCHCODE, 
@LIEF_A_NAME1, 
@LIEF_A_NAME2, 
@LIEF_A_PARTNER, 
@LIEF_A_STR, 
@LIEF_A_LAND, 
@LIEF_A_PLZ, 
@LIEF_A_ORT, 
@LIEF_A_TEL1, 
@LIEF_A_TEL2, 
@LIEF_A_FAX, 
@LIEF_A_EMAIL, 
@LIEF_A_URL, 
@LIEF_L_SPERRE, 
@LIEF_L_MWST, 
@LIEF_N_MWSTKENNUNG, 
@LIEF_L_EUKUNDE, 
@LIEF_L_AUSLAND, 
@LIEF_A_NOTIZ, 
@LIEF_A_WAEHRUNG, 
@LIEF_A_KUNDENNR, 
@LIEF_A_KONTO, 
@LIEF_A_IBAN, 
@LIEF_A_BLZ, 
@LIEF_A_BIC, 
@LIEF_A_KONTOINHABER, 
@LIEF_A_BANKNAME, 
@LIEF_N_LIBD, 
@LIEF_N_ZABD, 
@LIEF_N_MIDBESTWERT, 
@LIEF_N_FRACHTFR_AB, 
@LIEF_A_KREDITORNR, 
@LIEF_A_SELEKTION1, 
@LIEF_A_SELEKTION2, 
@LIEF_A_SELEKTION3, 
@LIEF_L_LIEFABWEICHEND, 
@LIEF_A_USTIDNR, 
@LIEF_N_RABATT, 
@LIEF_L_RUECKGABE, 
@LIEF_N_RUECKGABE_TAGE, 
@LIEF_L_BONUS, 
@LIEF_N_BONUS1PROZ, 
@LIEF_N_BONUS1WERT, 
@LIEF_N_BONUS2PROZ, 
@LIEF_N_BONUS2WERT,
@LIEF_N_BONUS3PROZ, 
@LIEF_N_BONUS3WERT, 
@LIEF_N_RMAART, 
@LIEF_L_MINDESTLOHN, 
@LIEF_L_PARGR13B, 
@LIEF_D_PARGR13B, 
@LIEF_L_PARGR48B, 
@LIEF_D_PARGR48B, 
@LIEF_WK5_N_VERSANDKOSTEN, 
@LIEF_WK5_N_VERPACKKOSTEN, 
@LIEF_WK5_N_VERSICHERKOSTEN,
@LIEF_WK5_B_SHOPPASSWORT, 
@LIEF_WK5_B_SHOPUSERNAME, 
@LIEF_WK5_L_AUTOIMPORT, 
@LIEF_WK5_N_MINDERMENGENZUSCHLAG,
@LIEF_A_WARNHINWEISE,
@LIEF_L_EIGENLIEFERANT
)
");




            lieferant.LIEF_N_NR = lieferantennummer;
            await _fbController.CommitChangesAsync();

            return lieferant;
        }

        public static async Task UpdateLieferantAsync(Lieferant lieferant, int userid)
        {
            if (lieferant.LIEF_N_NR <= 0)
            {
                throw new ArgumentException("Der Lieferant verfügt über keine Lieferantennummer");
            }

            using FbController2 _fbController = new FbController2(userid);
            #region Parameter            
            _fbController.AddParameter("@LIEF_N_NR", lieferant.LIEF_N_NR);
            _fbController.AddParameter("@LIEF_A_SUCHCODE", lieferant.LIEF_A_SUCHCODE);
            _fbController.AddParameter("@LIEF_A_NAME1", lieferant.LIEF_A_NAME1);
            _fbController.AddParameter("@LIEF_A_NAME2", lieferant.LIEF_A_NAME2);
            _fbController.AddParameter("@LIEF_A_PARTNER", lieferant.LIEF_A_PARTNER);
            _fbController.AddParameter("@LIEF_A_STR", lieferant.LIEF_A_STR);
            _fbController.AddParameter("@LIEF_A_LAND", lieferant.LIEF_A_LAND);
            _fbController.AddParameter("@LIEF_A_PLZ", lieferant.LIEF_A_PLZ);
            _fbController.AddParameter("@LIEF_A_ORT", lieferant.LIEF_A_ORT);
            _fbController.AddParameter("@LIEF_A_TEL1", lieferant.LIEF_A_TEL1);
            _fbController.AddParameter("@LIEF_A_TEL2", lieferant.LIEF_A_TEL2);
            _fbController.AddParameter("@LIEF_A_FAX", lieferant.LIEF_A_FAX);
            _fbController.AddParameter("@LIEF_A_EMAIL", lieferant.LIEF_A_EMAIL);
            _fbController.AddParameter("@LIEF_A_URL", lieferant.LIEF_A_URL);
            _fbController.AddParameter("@LIEF_L_SPERRE", lieferant.LIEF_L_SPERRE ? "Y" : "N");
            _fbController.AddParameter("@LIEF_L_MWST", lieferant.LIEF_L_MWST ? "Y" : "N");
            _fbController.AddParameter("@LIEF_N_MWSTKENNUNG", lieferant.LIEF_N_MWSTKENNUNG);
            _fbController.AddParameter("@LIEF_L_EUKUNDE", lieferant.LIEF_L_EUKUNDE ? "Y" : "N");
            _fbController.AddParameter("@LIEF_L_AUSLAND", lieferant.LIEF_L_AUSLAND ? "Y" : "N");
            _fbController.AddParameter("@LIEF_A_NOTIZ", lieferant.LIEF_A_NOTIZ);
            _fbController.AddParameter("@LIEF_A_WAEHRUNG", lieferant.LIEF_A_WAEHRUNG);
            _fbController.AddParameter("@LIEF_A_KUNDENNR", lieferant.LIEF_A_KUNDENNR);
            _fbController.AddParameter("@LIEF_A_KONTO", lieferant.LIEF_A_KONTO);
            _fbController.AddParameter("@LIEF_A_IBAN", lieferant.LIEF_A_IBAN);
            _fbController.AddParameter("@LIEF_A_BLZ", lieferant.LIEF_A_BLZ);
            _fbController.AddParameter("@LIEF_A_BIC", lieferant.LIEF_A_BIC);
            _fbController.AddParameter("@LIEF_A_KONTOINHABER", lieferant.LIEF_A_KONTOINHABER);
            _fbController.AddParameter("@LIEF_A_BANKNAME", lieferant.LIEF_A_BANKNAME);
            _fbController.AddParameter("@LIEF_N_LIBD", lieferant.LIEF_N_LIBD);
            _fbController.AddParameter("@LIEF_N_ZABD", lieferant.LIEF_N_ZABD);
            _fbController.AddParameter("@LIEF_N_MIDBESTWERT", lieferant.LIEF_N_MIDBESTWERT);
            _fbController.AddParameter("@LIEF_N_FRACHTFR_AB", lieferant.LIEF_N_FRACHTFR_AB);
            _fbController.AddParameter("@LIEF_A_KREDITORNR", lieferant.LIEF_A_KREDITORNR);
            _fbController.AddParameter("@LIEF_A_SELEKTION1", lieferant.LIEF_A_SELEKTION1);
            _fbController.AddParameter("@LIEF_A_SELEKTION2", lieferant.LIEF_A_SELEKTION2);
            _fbController.AddParameter("@LIEF_A_SELEKTION3", lieferant.LIEF_A_SELEKTION3);
            _fbController.AddParameter("@LIEF_L_LIEFABWEICHEND", lieferant.LIEF_L_LIEFABWEICHEND ? "Y" : "N");
            _fbController.AddParameter("@LIEF_A_USTIDNR", lieferant.LIEF_A_USTIDNR);
            _fbController.AddParameter("@LIEF_N_RABATT", lieferant.LIEF_N_RABATT);
            _fbController.AddParameter("@LIEF_L_RUECKGABE", lieferant.LIEF_L_RUECKGABE ? "Y" : "N");
            _fbController.AddParameter("@LIEF_N_RUECKGABE_TAGE", lieferant.LIEF_N_RUECKGABE_TAGE);
            _fbController.AddParameter("@LIEF_L_BONUS", lieferant.LIEF_L_BONUS ? "Y" : "N");
            _fbController.AddParameter("@LIEF_N_BONUS1PROZ", lieferant.LIEF_N_BONUS1PROZ);
            _fbController.AddParameter("@LIEF_N_BONUS1WERT", lieferant.LIEF_N_BONUS1WERT);
            _fbController.AddParameter("@LIEF_N_BONUS2PROZ", lieferant.LIEF_N_BONUS2PROZ);
            _fbController.AddParameter("@LIEF_N_BONUS2WERT", lieferant.LIEF_N_BONUS2WERT);
            _fbController.AddParameter("@LIEF_N_BONUS3PROZ", lieferant.LIEF_N_BONUS3PROZ);
            _fbController.AddParameter("@LIEF_N_BONUS3WERT", lieferant.LIEF_N_BONUS3WERT);
            _fbController.AddParameter("@LIEF_N_RMAART", lieferant.LIEF_N_RMAART);
            _fbController.AddParameter("@LIEF_L_MINDESTLOHN", lieferant.LIEF_L_MINDESTLOHN ? "Y" : "N");
            _fbController.AddParameter("@LIEF_L_PARGR13B", lieferant.LIEF_L_PARGR13B ? "Y" : "N");
            _fbController.AddParameter("@LIEF_D_PARGR13B", lieferant.LIEF_D_PARGR13B);
            _fbController.AddParameter("@LIEF_L_PARGR48B", lieferant.LIEF_L_PARGR48B ? "Y" : "N");
            _fbController.AddParameter("@LIEF_D_PARGR48B", lieferant.LIEF_D_PARGR48B);
            _fbController.AddParameter("@LIEF_WK5_N_VERSANDKOSTEN", lieferant.LIEF_WK5_N_VERSANDKOSTEN);
            _fbController.AddParameter("@LIEF_WK5_N_VERPACKKOSTEN", lieferant.LIEF_WK5_N_VERPACKKOSTEN);
            _fbController.AddParameter("@LIEF_WK5_N_VERSICHERKOSTEN", lieferant.LIEF_WK5_N_VERSICHERKOSTEN);
            _fbController.AddParameter("@LIEF_WK5_B_SHOPPASSWORT", lieferant.LIEF_WK5_B_SHOPPASSWORT);
            _fbController.AddParameter("@LIEF_WK5_B_SHOPUSERNAME", lieferant.LIEF_WK5_B_SHOPUSERNAME);
            _fbController.AddParameter("@LIEF_WK5_L_AUTOIMPORT", lieferant.LIEF_WK5_L_AUTOIMPORT);
            _fbController.AddParameter("@LIEF_WK5_L_DIREKT_ERLAUBT", lieferant.LIEF_WK5_L_DIREKT_ERLAUBT);
            _fbController.AddParameter("@LIEF_WK5_N_MINDERMENGENZUSCHLAG", lieferant.Mindermengenzuschlag);
            _fbController.AddParameter("@LIEF_A_WARNHINWEISE", lieferant.LIEF_A_WARNHINWEISE);
            _fbController.AddParameter("@LIEF_L_EIGENLIEFERANT", lieferant.LIEF_L_EIGENLIEFERANT.ToFirebirdBool());
            #endregion
            await _fbController.QueryAsync(@"UPDATE LIEFERANTEN SET
LIEF_A_SUCHCODE = @LIEF_A_SUCHCODE, 
LIEF_A_NAME1 = @LIEF_A_NAME1, 
LIEF_A_NAME2 = @LIEF_A_NAME2,
LIEF_A_PARTNER = @LIEF_A_PARTNER, 
LIEF_A_STR = @LIEF_A_STR,
LIEF_A_LAND = @LIEF_A_LAND, 
LIEF_A_PLZ = @LIEF_A_PLZ,
LIEF_A_ORT = @LIEF_A_ORT, 
LIEF_A_TEL1 = @LIEF_A_TEL1, 
LIEF_A_TEL2 = @LIEF_A_TEL2, 
LIEF_A_FAX = @LIEF_A_FAX,
LIEF_A_EMAIL = @LIEF_A_EMAIL, 
LIEF_A_URL = @LIEF_A_URL,
LIEF_L_SPERRE = @LIEF_L_SPERRE, 
LIEF_L_MWST = @LIEF_L_MWST,
LIEF_N_MWSTKENNUNG = @LIEF_N_MWSTKENNUNG, 
LIEF_L_EUKUNDE = @LIEF_L_EUKUNDE, 
LIEF_L_AUSLAND = @LIEF_L_AUSLAND,
LIEF_A_NOTIZ = @LIEF_A_NOTIZ, 
LIEF_A_WAEHRUNG = @LIEF_A_WAEHRUNG, 
LIEF_A_KUNDENNR = @LIEF_A_KUNDENNR, 
LIEF_A_KONTO = @LIEF_A_KONTO,
LIEF_A_IBAN = @LIEF_A_IBAN, 
LIEF_A_BLZ = @LIEF_A_BLZ, 
LIEF_A_BIC = @LIEF_A_BIC, 
LIEF_A_KONTOINHABER = @LIEF_A_KONTOINHABER,
LIEF_A_BANKNAME = @LIEF_A_BANKNAME, 
LIEF_N_LIBD = @LIEF_N_LIBD, 
LIEF_N_ZABD = @LIEF_N_ZABD, 
LIEF_N_MIDBESTWERT = @LIEF_N_MIDBESTWERT,
LIEF_N_FRACHTFR_AB = @LIEF_N_FRACHTFR_AB, 
LIEF_A_KREDITORNR = @LIEF_A_KREDITORNR, 
LIEF_A_SELEKTION1 = @LIEF_A_SELEKTION1,
LIEF_A_SELEKTION2 = @LIEF_A_SELEKTION2, 
LIEF_A_SELEKTION3 = @LIEF_A_SELEKTION3, 
LIEF_L_LIEFABWEICHEND = @LIEF_L_LIEFABWEICHEND,
LIEF_A_USTIDNR = @LIEF_A_USTIDNR, 
LIEF_N_RABATT = @LIEF_N_RABATT, 
LIEF_L_RUECKGABE = @LIEF_L_RUECKGABE,
LIEF_N_RUECKGABE_TAGE = @LIEF_N_RUECKGABE_TAGE, 
LIEF_L_BONUS = @LIEF_L_BONUS, 
LIEF_N_BONUS1PROZ = @LIEF_N_BONUS1PROZ,
LIEF_N_BONUS1WERT = @LIEF_N_BONUS1WERT, 
LIEF_N_BONUS2PROZ = @LIEF_N_BONUS2PROZ, 
LIEF_N_BONUS2WERT = @LIEF_N_BONUS2WERT,
LIEF_N_BONUS3PROZ = @LIEF_N_BONUS3PROZ, 
LIEF_N_BONUS3WERT = @LIEF_N_BONUS3WERT, 
LIEF_N_RMAART = @LIEF_N_RMAART, 
LIEF_L_MINDESTLOHN = @LIEF_L_MINDESTLOHN, 
LIEF_L_PARGR13B = @LIEF_L_PARGR13B,
LIEF_D_PARGR13B = @LIEF_D_PARGR13B, 
LIEF_L_PARGR48B = @LIEF_L_PARGR48B, 
LIEF_D_PARGR48B = @LIEF_D_PARGR48B,
LIEF_WK5_N_VERSANDKOSTEN = @LIEF_WK5_N_VERSANDKOSTEN, 
LIEF_WK5_N_VERPACKKOSTEN = @LIEF_WK5_N_VERPACKKOSTEN, 
LIEF_WK5_N_VERSICHERKOSTEN = @LIEF_WK5_N_VERSICHERKOSTEN,
LIEF_WK5_B_SHOPPASSWORT = @LIEF_WK5_B_SHOPPASSWORT,  
LIEF_WK5_B_SHOPUSERNAME = @LIEF_WK5_B_SHOPUSERNAME,
LIEF_WK5_L_AUTOIMPORT = @LIEF_WK5_L_AUTOIMPORT, 
LIEF_WK5_L_DIREKT_ERLAUBT = @LIEF_WK5_L_DIREKT_ERLAUBT,
LIEF_WK5_N_MINDERMENGENZUSCHLAG = @LIEF_WK5_N_MINDERMENGENZUSCHLAG,
LIEF_A_WARNHINWEISE = @LIEF_A_WARNHINWEISE,
LIEF_L_EIGENLIEFERANT = @LIEF_L_EIGENLIEFERANT
WHERE LIEF_N_NR = @LIEF_N_NR");
            return;
        }

        public static async IAsyncEnumerable<int> GetFreieLieferantennummernW4Async()
        {
            using FbController2 _fbController = new FbController2();
            DataTable lieferantenNummern = await _fbController.SelectDataAsync("SELECT LIEF_N_NR FROM LIEFERANTEN WHERE LIEF_N_NR > 70000 ORDER BY LIEF_N_NR ASC");
            HashSet<int> w4Lieferanten = lieferantenNummern.AsEnumerable().Select(s => s.Field<int>("LIEF_N_NR")).ToHashSet<int>();
            var freieNummern = HashSetErweiterung.FindeFehlendeNummern(w4Lieferanten);
            if (!freieNummern.Any())
            {
                freieNummern.Append(w4Lieferanten.Max() + 1);
            }

            DataRow? nummernKreis = await _fbController.SelectRowAsync("SELECT * FROM NUMKREISE WHERE NUMK_N_ID = 1");

            if (nummernKreis is not null)
            {
                var list = freieNummern.ToList();
                list.RemoveAll(x => x < nummernKreis.Field<int>("NUMK_N_LIEF_VON") || x > nummernKreis.Field<int>("NUMK_N_LIEF_BIS"));
                foreach (int item in list)
                {
                    yield return item;
                }
            }
            else
            {
                foreach (int item in freieNummern)
                {
                    yield return item;
                }
            }
        }

        public static async Task UpdateParsedTelefonnummern(int lieferantennummer, FbController2? fbController = null)
        {
            Lieferant? lieferant = await Lieferant.GetLieferantAsync(lieferantennummer);
            if (lieferant is not null)
            {
                await lieferant.UpdateParsedTelefonnummern(fbController);
            }
        }

        public async Task UpdateParsedTelefonnummern(FbController2? fbController = null)
        {
            await Telefonnummer.DeleteAsync(LIEF_N_NR.ToString(), "LI");

            if (!String.IsNullOrWhiteSpace(LIEF_A_TEL1))
            {
                await Telefonnummer.InsertOrUpdateAsync(LIEF_N_NR.ToString(), "LI", Telefonnummer.Sanitize(LIEF_A_TEL1), fbController);
            }

            if (!String.IsNullOrWhiteSpace(LIEF_A_TEL2))
            {
                await Telefonnummer.InsertOrUpdateAsync(LIEF_N_NR.ToString(), "LI", Telefonnummer.Sanitize(LIEF_A_TEL2), fbController);
            }

            List<LieferantenPartner> lieferantenPartner = await LieferantenPartner.GetLieferantenPartnerAsync(LIEF_N_NR).ToListAsync();
            foreach (LieferantenPartner partner in lieferantenPartner)
            {
                if (!String.IsNullOrWhiteSpace(partner.LIEP_A_TELEFON))
                {
                    await Telefonnummer.InsertOrUpdateAsync(LIEF_N_NR.ToString(), "LI", Telefonnummer.Sanitize(partner.LIEP_A_TELEFON), fbController);
                }
            }

            List<LieferantenAnschrift> lieferantenAnschriften = await LieferantenAnschrift.GetAnschriftenAsync(LIEF_N_NR).ToListAsync();
            foreach (LieferantenAnschrift anschrift in lieferantenAnschriften)
            {
                if (!String.IsNullOrWhiteSpace(anschrift.LIRE_A_TEL))
                {
                    await Telefonnummer.InsertOrUpdateAsync(LIEF_N_NR.ToString(), "LI", Telefonnummer.Sanitize(anschrift.LIRE_A_TEL), fbController);
                }
            }
        }
    }
}
