﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;

namespace WK5.Core.Models
{
    public class LastschriftRechnungExport
    {
        [CompareField("BELE_N_NR")]
        public int Rechnungsnummer { get; set; }
        [CompareField("BELE_N_BRUTTO")]
        public decimal Betrag { get; set; }
        [CompareField("KUND_A_IBAN")]
        public string? Iban { get; set; }
        [CompareField("KUND_A_BIC")]
        public string? Bic { get; set; }
        [CompareField("KUND_A_NR")]
        public string Kundennummer { get; set; } = String.Empty;
        [CompareField("BELE_N_ZAHLUNG")]
        public int ZahlungsbedingungId { get; set; }
        [CompareField("BELE_D_DATE")]
        public DateTime Rechnungsdatum { get; set; }
        [CompareField("BELE_N_NETTO")]
        public decimal Netto { get; set; }
        [CompareField("KUND_A_NAME1")]
        public string Kundenname { get; set; } = String.Empty;
        [CompareField("KUND_A_LAND")]
        public string Kundenland { get; set; } = String.Empty;

        [CompareField("KUND_WK5_D_AUSSTELLUNG_MANDAT")]
        public DateTime MandatsAusstellungsdatum { get; set; }
        public bool Exportieren { get; set; }

        public bool ExportierenErlaubt()
        {
            if (MandatsAusstellungsdatum == default)
            {
                return false;
            }

            if (String.IsNullOrWhiteSpace(Iban))
            {
                return false;
            }
            else if (!StringErweiterung.ValidateIBAN(Iban))
            {
                return false;
            }

            if (String.IsNullOrWhiteSpace(Bic))
            {
                return false;
            }
            else if (!StringErweiterung.ValidateBIC(Bic))
            {
                return false;
            }

            return true;
        }

        public string GetRowClass() => ExportierenErlaubt() ? String.Empty : "table-danger";
    }
}
