﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Stellt ein Land aus der W4 dar.
    /// </summary>
    public class Land
    {
        #region Datenbankfelder
        // Die Attribute spiegeln vollständig die Spalten des Table LANDESKENNZEICHEN der Datenbank wieder 
        public string LAND_A_ID { get; private set; } = String.Empty;
        public string LAND_A_NAME { get; private set; } = String.Empty;
        public DateTime LAND_TIMESTAMP { get; set; }
        public int LAND_N_LASTUSER { get; set; }
        public bool WK5_LAND_L_ISTEULAND { get; set; }
        #endregion

        /// <summary>
        /// Liefert alle Länder aus der Datenbank zurück.
        /// </summary>
        public static async IAsyncEnumerable<Land> GetLänderAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM LANDESKENNZEICHEN ORDER BY LAND_A_NAME");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Land(), row);
            }
        }

        /// <summary>
        /// Holt ein Land anhand seiner Landes ID
        /// </summary>
        /// <param name="id">Die ID des Landes</param>
        /// <returns>Gibt ein Objekt der Klasse <see cref="Land"/> zurück</returns>
        public static async Task<Land?> GetLandAsync(string LAND_A_ID, FbController2 fbController)
        {
            fbController.AddParameter("@LAND_A_ID", LAND_A_ID);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM LANDESKENNZEICHEN WHERE LAND_A_ID = @LAND_A_ID");
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Land(), row);
        }

        public static async IAsyncEnumerable<Land> GetEuLänderAsync(bool ignoreDeutschland = true)
        {
            using FbController2 fbController = new FbController2();
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM LANDESKENNZEICHEN WHERE WK5_LAND_L_ISTEULAND = 'Y' ORDER BY LAND_A_NAME");

            foreach (DataRow row in data.Rows)
            {
                Land land = ObjectErweiterung.DataRowZuObjekt<Land>(new Land(), row);
                if (ignoreDeutschland && land.LAND_A_ID.Equals("DE", StringComparison.OrdinalIgnoreCase))
                {
                    continue;
                }

                yield return land;
            }
        }




    }
}
