﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Stellt eine Lagerposition aus der W4 dar.
    /// </summary>
    public class Lagerplatz
    {
        #region Datenbankfelder
        #region Alphanumerische Werte
        public string LAGE_A_ABCPLATZ { get; set; } = String.Empty;
        public string LAGE_A_HILFSMIT { get; set; } = String.Empty;
        public string LAGE_A_NAME { get; set; } = String.Empty;
        public string LAGE_A_NR { get; set; } = String.Empty;
        public string LAGE_A_URSACHE { get; set; } = String.Empty;
        public string WK5_LAGE_A_HAUPTLAGER { get; set; } = String.Empty;
        #endregion
        #region Datums Werte
        public DateTime LAGE_D_FREIGEW { get; set; }
        public DateTime LAGE_TIMESTAMP { get; set; }
        #endregion
        #region Logische Werte
        public bool LAGE_L_BELEGT { get; set; }
        public bool LAGE_L_EXTERN { get; set; }
        public bool LAGE_L_GESPERRT { get; set; }
        public bool LAGE_L_HAUPTLAGER { get; set; }
        public bool LAGE_L_KONTROLLE { get; set; }
        public bool LAGE_L_PALETTE { get; set; }
        #endregion
        #region Numerische Werte
        public int LAGE_N_AUSLAST { get; set; }
        public int LAGE_N_BREITE { get; set; }
        public int LAGE_N_EBENE { get; set; }
        public int LAGE_N_FILIALE { get; set; }
        public int LAGE_N_LASTUSER { get; set; }
        public decimal LAGE_N_HOEHE { get; set; }
        public decimal LAGE_N_MAXLAST { get; set; }
        public decimal LAGE_N_MENGE { get; set; }
        public decimal LAGE_N_VOLUMEN { get; set; }
        #endregion
        #endregion

        /// <summary>
        /// Holt sich die Daten für das Lager mit der gegebenen Nr aus der Datenbank
        /// </summary>
        /// <param name="LAGE_A_NR">Die Identifikationsnummer des zu suchenden Lagers</param>
        /// <returns>Gibt ein Objekt der Klasse <see cref="Lager"/> zurück</returns>
        public static async Task<Lagerplatz?> GetLagerAsync(string LAGE_A_NR)
        {
            using FbController2 fbController = new FbController2();
            fbController.AddParameter("@LAGERPLATZ", LAGE_A_NR);
            var row = await fbController.SelectRowAsync($"SELECT * FROM LAGER WHERE UPPER(LAGE_A_NR) = @LAGERPLATZ");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Lagerplatz(), row);
        }


        /// <summary>
        /// Holt sich alle Lager aus der Datenbank
        /// </summary>
        public static async IAsyncEnumerable<Lagerplatz> GetAllLagerAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM LAGER ORDER BY LAGE_N_LAGER, LAGE_N_REGAL, LAGE_N_FACH");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Lagerplatz(), row);
            }
        }
    }
}
