﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace WK5.Core.Models.Lager
{
    public class RechnungBuchenInput : LieferscheinBuchenInput
    {
        private string _rechnungsnummer = String.Empty;

        public int Zugangsnummer { get; set; }
        public string Rechnungsnummer
        {
            get => _rechnungsnummer;
            set
            {
                if (value is null)
                {
                    _rechnungsnummer = String.Empty;
                }
                else
                {

                    _rechnungsnummer = value.Trim().Replace(" ", String.Empty);
                }
            }

        }
        public DateTime Rechnungsdatum { get; set; } = DateTime.Now;
        public DateTime Zugangsdatum { get; set; } = DateTime.Now;
        public int Personalnummer { get; set; }
        public decimal GesamtbetragNetto { get; set; }
        public bool Gesperrt { get; }

        public string? Rechnungsdatei { get; set; }
        public bool InternerZugang { get; set; } = false;

        [Obsolete("Diese Funktion hat die Mwst Berechnung nicht richtig beachtet!")]
        public decimal GesamtBrutto(Mehrwertsteuer? versandMehrwertsteuer) => Math.Round(versandMehrwertsteuer is null
            ? Positionen.Sum(x => x.Preis * x.Menge * ((100 + x.MwstSatz) / 100)) + Zusatzkosten
            : Positionen.Sum(x => x.Preis * x.Menge * ((100 + x.MwstSatz) / 100)) + Zusatzkosten + (Zusatzkosten * versandMehrwertsteuer.MWST_N_PROZENT / 100), 2, MidpointRounding.AwayFromZero);

        public decimal GesamtBrutto(bool mwstBerechnen, Mehrwertsteuer? versandMehrwertsteuer)
        {
            decimal wert = 0.0m;
            if (mwstBerechnen)
            {
                wert = Positionen.Sum(x => x.Preis * x.Menge * ((100 + x.MwstSatz) / 100)) + Zusatzkosten;
            }
            else
            {
                wert = Positionen.Sum(x => x.Preis * x.Menge) + Zusatzkosten;
            }

            if (mwstBerechnen && versandMehrwertsteuer is not null)
            {
                wert += Zusatzkosten * versandMehrwertsteuer.MWST_N_PROZENT / 100;
            }

            return Math.Round(wert, 2, MidpointRounding.AwayFromZero);

        }


        public bool TeilRechnung { get; set; }

        public decimal NettoGesamtRechnung { get; set; }
        public int EcoDmsDocId { get; set; }
        public bool MwstBeiBearbeitung { get; set; }
        public decimal Zollkosten { get; set; }
        public override void SetGeprüftFürPosition(PositionBuchenInput pos)
        {
            pos.Geprüft = !pos.Geprüft;

            if (!Positionen.Where(x => !x.Geprüft).Any() && TeilRechnung)
            {
                GesamtbetragNetto = Positionen.Sum(x => x.Preis * x.Menge) + Zusatzkosten;
            }
        }

        public IEnumerable<int> GetAuftragsnummern()
        {
            return Positionen.Where(x => x.Auftragsnummer > 0).Select(x => x.Auftragsnummer).Distinct();
        }

        public RechnungBuchenInput(bool gesperrt)
        {
            Gesperrt = gesperrt;
        }
    }
}
