﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace WK5.Core.Models.Lager
{
    public class LieferscheinBuchenInput
    {
        private string _lieferscheinNummer = String.Empty;
        private string _notiz = string.Empty;

        public string LieferscheinNummer { get => _lieferscheinNummer; set => _lieferscheinNummer = value?.Trim() ?? String.Empty; }
        public DateTime LieferscheinDatum { get; set; } = DateTime.Now;
        public List<PositionBuchenInput> Positionen { get; } = new List<PositionBuchenInput>();
        public bool BenötigtSeriennummern => Positionen.Where(x => x.SeriennummerBenötigt).Any();
        public decimal Zusatzkosten { get; set; }
        public string Notiz { get => _notiz; set => _notiz = value ?? string.Empty; }
        public int RmaNummerVerknüpfung { get; set; }
        public ZugangBestellnotizInput? BestellungNotiz { get; set; }
        public int Bestellnummer { get; set; }

        public string? Lieferscheindatei { get; set; }
        public int EcoDmsLieferscheinDocId { get; set; }

        public bool Geprüft { get; set; }
        public string RowClass => Geprüft ? "table-success" : String.Empty;
        public virtual void SetGeprüftFürPosition(PositionBuchenInput pos)
        {
            pos.Geprüft = !pos.Geprüft;
        }
    }
}
