﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using WK5.Core.Models.Versand;

namespace WK5.Core.Models.Lager
{
    public class DirektlieferungFortführenInput
    {
        private Courier _versender = Courier.UPS;

        public Courier Versender
        {
            get => _versender;
            set
            {
                _versender = value;

                if (value is Courier.OHNETRACKINGNUMMER)
                {
                    foreach (var paket in Pakete)
                    {
                        paket.Trackingnummer = "OHNE";
                    }
                }
            }
        }
        public List<PaketInput> Pakete { get; } = new List<PaketInput>();
        public int AnzahlPakete { get; private set; } = 0;
        public void AddPaket()
        {
            PaketInput input = new PaketInput { Paketnummer = ++AnzahlPakete };
            if (Versender is Courier.OHNETRACKINGNUMMER)
            {
                input.Trackingnummer = "OHNE";
            }

            Pakete.Add(input);
        }

        public void RemovePaket() => Pakete.RemoveAt(--AnzahlPakete);

        public DirektlieferungFortführenInput()
        {
            AddPaket();
        }
    }
}
