﻿using System;

namespace WK5.Core.Models.Lager
{
    public class AbgangBuchenInput
    {
        private decimal _maxMenge = 1;

        public string Artikelnummer { get; set; } = String.Empty;
        public decimal Menge { get; set; } = 1;
        public int Charge { get; set; }
        public string Seriennummer { get; set; } = String.Empty;
        public int Kostenstelle { get; set; }
        public DateTime Datum { get; set; } = DateTime.Now;
        public string Notiz { get; set; } = String.Empty;
        public bool BenötigtSeriennummer { get; set; }

        public decimal MaxMenge { get => _maxMenge; set => _maxMenge = value <= 0 ? 1 : value; }
        /// <summary>
        /// Ruft einen Wert ab, der angibt, ob das Formular zu editieren bereit ist, oder nicht.
        /// <para>
        /// Das Formular ist dann bereit, wenn alle folgenden Bedingungen erfüllt sind:
        /// <list type="bullet">
        /// <item>Eine Artikelnummer ausgewählt wurde</item>
        /// <item>Eine Charge ausgewählt wurde</item>
        /// <item>Sofern der Artikel es erfordert, eine Seriennummer ausgewählt worden ist.</item>
        /// </list>
        /// </para>
        /// </summary>
        public bool EditModeAvailable => !String.IsNullOrWhiteSpace(Artikelnummer)
            && Charge > 0
            && (!BenötigtSeriennummer || (BenötigtSeriennummer && !String.IsNullOrWhiteSpace(Seriennummer)));
    }
}
