﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter;
using WK5.Core.PageModels.Stammdaten.Kunden;

namespace WK5.Core.Models
{
    public class Kundenkontakt
    {

        #region Datenbankfelder
        public string KUKO_A_KUNDNR { get; set; } = String.Empty;
        public string KUKO_A_NOTIZ { get; set; } = String.Empty;
        public string? KUKO_A_PARTNER { get; set; }
        public string? KUKO_A_UNWG1 { get; set; }
        public string? KUKO_A_UNWG2 { get; set; }
        public string? KUKO_A_UNWG3 { get; set; }
        public string? KUKO_A_WG1 { get; set; }
        public string? KUKO_A_WG2 { get; set; }
        public string? KUKO_A_WG3 { get; set; }
        public bool KUKO_L_WIEDERV_ERL { get; set; }
        public int KUKO_N_ART { get; set; }
        public int KUKO_N_BELEGNR_AN { get; set; }
        public int KUKO_N_BELEGNR_AU { get; set; }
        public int KUKO_N_ID { get; set; }
        public int KUKO_N_LASTUSER { get; set; }
        public int KUKO_N_WIEDERV_USER { get; set; }
        public DateTime KUKO_T_TIME
        {
            get => _time;
            set
            {
                DateTime dateTime = value;
                dateTime = dateTime.AddSeconds(-dateTime.Second);
                _time = dateTime;
            }
        }
        public DateTime KUKO_T_WIEDERV_TIME
        {
            get => _wiedervorlageTime;
            set
            {
                DateTime dateTime = value;
                dateTime = dateTime.AddSeconds(-dateTime.Second);
                _wiedervorlageTime = dateTime;
            }

        }
        public DateTime KUKO_TIMESTAMP { get; set; }
        public DateTime KUKO_D_DATE { get; set; }
        public DateTime KUKO_D_WIEDERV_DATE { get; set; }


        private string? _langnotiz;
        private DateTime _time;
        private DateTime _wiedervorlageTime;
        private string _belegtyp = string.Empty;

        public string? KUKO_WK5_B_LANGNOTIZ
        {
            get
            {
                if (String.IsNullOrWhiteSpace(_langnotiz) && !String.IsNullOrWhiteSpace(KUKO_A_NOTIZ))
                {
                    return KUKO_A_NOTIZ;
                }
                else
                {
                    return _langnotiz;
                }
            }

            set
            {
                _langnotiz = value;
            }
        }

        public int KUKO_WK5_N_NOTIFICATION_ID { get; set; }
        public string? KUKO_WK5_A_BETREFF { get; set; }

        public string KUKO_A_BELEGTYP { get => _belegtyp; set => _belegtyp = value ?? string.Empty; }
        public int KUKO_N_BELEGNR { get; set; }

        #endregion



        public static async IAsyncEnumerable<Kundenkontakt> GetKundenkontakteAsync(string KUKO_A_KUNDNR, int KUKO_N_ART, [EnumeratorCancellation] CancellationToken cancellationToken)
        {
            if (!cancellationToken.IsCancellationRequested)
            {
                using FbController2 fbController = new FbController2();
                fbController.AddParameter("@KUKO_A_KUNDNR", KUKO_A_KUNDNR);
                fbController.AddParameter("@KUKO_N_ART", KUKO_N_ART);
                var data = await fbController.SelectDataAsync($"SELECT * FROM KUNDENKONTAKTE WHERE KUKO_A_KUNDNR = @KUKO_A_KUNDNR AND KUKO_N_ART = @KUKO_N_ART ORDER BY KUKO_N_ID DESC");

                foreach (DataRow row in data.Rows)
                {
                    if (cancellationToken.IsCancellationRequested)
                    {
                        break;
                    }
                    yield return ObjectErweiterung.DataRowZuObjekt(new Kundenkontakt(), row);
                }
            }
        }



    }
}
