﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.Models
{
    /// <summary>
    /// Spiegelt den Datenbank Table KUNDENGRUPPE wieder
    /// </summary>
    public class Kundengruppe
    {
        #region Datenbankfelder
        // Die Attribute spiegeln vollständig die Spalten des Table KUNDENGRUPPE der Datenbank wieder 
        public int KUGR_N_NR { get; set; }
        public string KUGR_A_BEZEICH { get; set; } = String.Empty;
        public bool KUGR_L_SAMMELBELEG { get; set; }
        public DateTime KUGR_TIMESTAMP { get; set; }
        public int KUGR_N_LASTUSER { get; set; }
        #endregion

        /// <summary>
        /// Holt sich alle Kundengruppen aus der Datenbank
        /// </summary>
        /// <returns>Gibt ein Objekt der Klasse <see cref="List{T}"/> zurück wo T ein Objekt der Klasse <see cref="Kundengruppe"/> ist</returns>
        public static async IAsyncEnumerable<Kundengruppe> GetKundengruppenAsync(FbController2 fbController)
        {
            var data = await fbController.SelectDataAsync("SELECT KUGR_N_NR, KUGR_A_BEZEICH FROM KUNDENGRUPPE ORDER BY KUGR_A_BEZEICH");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Kundengruppe(), row);
            }
        }

        /// <summary>
        /// Holt sich eine Kundengruppe anhand ihrer Nummer aus der Datenbank
        /// </summary>
        /// <param name="KUGR_N_NR">Die Nummer der Kundengruppe</param>
        /// <returns>Gibt ein Objekt der Klasse <see cref="Kundengruppe"/> zurück</returns>
        public static async Task<Kundengruppe?> GetKundengruppeAsync(int KUGR_N_NR, FbController2 fbController)
        {
            fbController.AddParameter("@KUGR_N_NR", KUGR_N_NR);
            DataRow? row = await fbController.SelectRowAsync($"SELECT * FROM KUNDENGRUPPE WHERE KUGR_N_NR = @KUGR_N_NR");
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Kundengruppe(), row);
        }
    }
}
