﻿using KarleyLibrary.Attributes;
using System;
using System.Text;

namespace WK5.Core.Models
{
    /// <summary>
    /// Diese Klasse stellt alle wichtigen Informationen eines Kunden gebündelt dar.
    /// </summary>
    public class KundenDetails
    {
        public string? Email { get; set; }
        public string? Fax { get; set; }
        public string? Tel { get; set; }
        public string? Preisliste { get; set; }
        public DateTime Erfassdatum { get; set; }
        public string? Vertreter { get; set; }
        public string? Zahlungsbedingung { get; set; }
        public decimal Jahresumsatz { get; set; }
        public decimal Gesamtumsatz { get; set; }
        [CompareField("LETZTE_RECHNUNG")]
        public DateTime LetzteRechnung { get; set; }
        public DateTime LetzterKontakt { get; set; }
        public DateTime Wiedervorlage { get; set; }
        public decimal OffenePosten { get; set; }
        [CompareField("OFFENEAUFTRAEGE")]
        public decimal OffeneAufträge { get; set; }
        public decimal NichtBerechnet { get; set; }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine($"Email: {Email}");
            sb.AppendLine($"Preisliste: {Preisliste}");
            sb.AppendLine($"Erfassdatum: {Erfassdatum}");
            sb.AppendLine($"Vertreter: {Vertreter}");
            sb.AppendLine($"Zahlungsbedingung: {Zahlungsbedingung}");
            sb.AppendLine($"Jahresumsatz: {Jahresumsatz}");
            sb.AppendLine($"Gesamtumsatz: {Gesamtumsatz}");
            sb.AppendLine($"LetzteRechnung: {LetzteRechnung}");
            sb.AppendLine($"LetzterKontakt: {LetzterKontakt}");
            sb.AppendLine($"Wiedervorlage: {Wiedervorlage}");
            sb.AppendLine($"OffenePosten: {OffenePosten}");
            sb.AppendLine($"OffeneAufträge: {OffeneAufträge}");
            sb.AppendLine($"NichtBerechnet: {NichtBerechnet}");

            return sb.ToString();
        }
    }
}
